/*
 * Decompiled with CFR 0.152.
 */
package de.uka.cmtm.serviceregistry.publish.uddi;

import de.uka.cmtm.serviceregistry.publish.uddi.MappingVersion;
import de.uka.cmtm.serviceregistry.publish.uddi.WsdlPublisher;
import de.uka.cmtm.serviceregistry.publish.uddi.wsdl.WsdlPublisherV01_08;
import de.uka.cmtm.serviceregistry.publish.uddi.wsdls.SaWsdlPublisherV01_08;
import java.net.URL;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.AuthToken;

public class WsdlPublisherFactory {
    private MappingVersion mappingVersion = MappingVersion.v01_08;
    private boolean saWsdlPublishingCapable = true;
    private String uddiInquiryUrl;
    private String uddiPublishUrl;
    private String uddiUser;
    private String uddiPassword;
    private String upperServiceOntologyUrl;

    public String getUpperServiceOntologyUrl() {
        return this.upperServiceOntologyUrl;
    }

    public void setUpperServiceOntologyUrl(String upperServiceOntologyUrl) {
        this.upperServiceOntologyUrl = upperServiceOntologyUrl;
    }

    public MappingVersion getMappingVersion() {
        return this.mappingVersion;
    }

    public void setMappingVersion(MappingVersion mappingVersion) {
        this.mappingVersion = mappingVersion;
    }

    public String getUddiInquiryUrl() {
        return this.uddiInquiryUrl;
    }

    public void setUddiInquiryUrl(String uddiInquiryUrl) {
        this.uddiInquiryUrl = uddiInquiryUrl;
    }

    public String getUddiPassword() {
        return this.uddiPassword;
    }

    public void setUddiPassword(String uddiPassword) {
        this.uddiPassword = uddiPassword;
    }

    public String getUddiPublishUrl() {
        return this.uddiPublishUrl;
    }

    public void setUddiPublishUrl(String uddiPublishUrl) {
        this.uddiPublishUrl = uddiPublishUrl;
    }

    public String getUddiUser() {
        return this.uddiUser;
    }

    public void setUddiUser(String uddiUser) {
        this.uddiUser = uddiUser;
    }

    public boolean isSaWsdlPublishingCapable() {
        return this.saWsdlPublishingCapable;
    }

    public void setSaWsdlPublishingCapable(boolean saWsdlPublishingCapable) {
        this.saWsdlPublishingCapable = saWsdlPublishingCapable;
    }

    public WsdlPublisher createWsdlPublisher() throws InstantiationException {
        if (this.uddiPublishUrl == null) {
            throw new IllegalStateException("UddiPublishUrl must be set prior to a call to createWsdlPublisher!");
        }
        if (this.uddiInquiryUrl == null) {
            throw new IllegalStateException("UddiInquiryUrl must be set prior to a call to createWsdlPublisher!");
        }
        if (this.uddiPassword == null) {
            throw new IllegalStateException("UddiPassword must be set prior to a call to createWsdlPublisher!");
        }
        if (this.uddiUser == null) {
            throw new IllegalStateException("UddiUser must be set prior to a call to createWsdlPublisher!");
        }
        try {
            UDDIProxy uddiProxy = new UDDIProxy(new URL(this.uddiInquiryUrl), new URL(this.uddiPublishUrl));
            AuthToken authToken = uddiProxy.get_authToken(this.uddiUser, this.uddiPassword);
            switch (this.mappingVersion) {
                case v01_08: {
                    if (this.isSaWsdlPublishingCapable()) {
                        if (this.upperServiceOntologyUrl == null) {
                            throw new IllegalStateException("UpperServiceOntologyUrl must be set before a wsdls-bupblishing capable WsdlPublisher can be created.");
                        }
                        return new SaWsdlPublisherV01_08(uddiProxy, authToken, this.upperServiceOntologyUrl);
                    }
                    return new WsdlPublisherV01_08(uddiProxy, authToken);
                }
            }
        }
        catch (Exception e) {
            InstantiationException ie = new InstantiationException("UDDI connection problem.");
            ie.initCause(e);
            throw ie;
        }
        return null;
    }
}

