/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdql.parser;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryPrintUtils;
import com.hp.hpl.jena.rdql.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdql.Var;
import com.hp.hpl.jena.rdql.parser.Expr;
import com.hp.hpl.jena.rdql.parser.ExprNode;
import com.hp.hpl.jena.rdql.parser.NodeValue;
import com.hp.hpl.jena.rdql.parser.Q_Identifier;
import com.hp.hpl.jena.rdql.parser.RDQLParser;
import com.hp.hpl.jena.rdql.parser.WorkingVar;
import java.io.PrintWriter;

public class Q_Var
extends ExprNode
implements Var,
Expr {
    String varName;
    int index;
    VariableIndexes varIndexes;

    public Q_Var(int n) {
        super(n);
    }

    public Q_Var(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void jjtClose() {
        if (this.jjtGetNumChildren() != 1) {
            throw new RDQL_InternalErrorException("Q_Var: expected 1 child: got " + this.jjtGetNumChildren());
        }
        this.varName = ((Q_Identifier)this.jjtGetChild((int)0)).id;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String string) {
        this.varName = string;
    }

    public NodeValue eval(Query query, IndexValues indexValues) {
        Node node = (Node)indexValues.get(this.index);
        if (node == null) {
            System.err.println("Oh dear: variable: " + this.varName);
            WorkingVar workingVar = new WorkingVar();
            workingVar.setString("unset: " + this.varName + "/" + this.index);
            return workingVar;
        }
        WorkingVar workingVar = new WorkingVar();
        workingVar.setNode(node);
        return workingVar;
    }

    public String toString() {
        return "?" + this.varName;
    }

    public String asInfixString() {
        return this.toString();
    }

    public String asPrefixString() {
        return this.toString();
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.indent(printWriter, n);
        printWriter.println(this.asPrefixString());
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        super.prepare(variableIndexes);
        this.varIndexes = variableIndexes;
        this.index = variableIndexes.indexOf(this.varName);
        return this;
    }

    public boolean isVariable() {
        return true;
    }

    public String getName() {
        return this.varName;
    }
}

