/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protege.widget.WidgetConfigurationPanel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public abstract class MultiWidgetPropertyWidget
extends AbstractPropertyWidget {
    private boolean allMode = false;
    private JPanel allPanel = new JPanel(new GridLayout(2, 1));
    private FrameListener valueListener = new FrameAdapter(){

        public void ownSlotValueChanged(FrameEvent event) {
            Slot slot = event.getSlot();
            for (AbstractSlotWidget slotWidget : MultiWidgetPropertyWidget.this.widgets) {
                if (!slot.equals(slotWidget.getSlot())) continue;
                slotWidget.loadValues();
            }
        }
    };
    private Instance instance;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private List widgets = new ArrayList();
    private Hashtable widgetContainers = new Hashtable();

    public MultiWidgetPropertyWidget() {
        this.tabbedPane.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 4));
        this.tabbedPane.setTabLayoutPolicy(1);
        this.createNestedWidgets();
    }

    public void addNestedWidget(SlotWidget widget, String slotName, String tabName, String widgetName) {
        this.widgets.add(widget);
        WidgetHolder wh = new WidgetHolder();
        this.tabbedPane.add(tabName, (Component)widget);
        wh.tabName = tabName;
        wh.widgetName = widgetName;
        wh.slotName = slotName;
        this.widgetContainers.put(widget, wh);
    }

    protected abstract void createNestedWidgets();

    protected WidgetDescriptor createWidgetDescriptor(SlotWidget widget, Cls cls, Slot slot) {
        WidgetHolder wc = (WidgetHolder)this.widgetContainers.get(widget);
        WidgetDescriptor d = this.getPropertyList().createWidgetDescriptor(slot.getName());
        if (wc != null && wc.widgetName != null) {
            d.setLabel(wc.widgetName);
        }
        return d;
    }

    public void dispose() {
        super.dispose();
        for (SlotWidget widget : this.widgets) {
            widget.dispose();
        }
        if (this.instance != null) {
            this.instance.removeFrameListener(this.valueListener);
        }
    }

    public WidgetConfigurationPanel createWidgetConfigurationPanel() {
        return new MultiWidgetConfigurationPanel(this);
    }

    public RDFResource getEditedResource() {
        return (RDFResource)this.instance;
    }

    protected JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private WidgetHolder getWidgetHolder(SlotWidget widget) {
        return (WidgetHolder)this.widgetContainers.get(widget);
    }

    protected void initAllPanel(JPanel allPanel, List widgets) {
        allPanel.setLayout(new GridLayout(widgets.size(), 1));
        int i = widgets.size() - 1;
        while (i >= 0) {
            Component widget = (Component)widgets.get(i);
            allPanel.add(widget);
            --i;
        }
    }

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.tabbedPane);
        for (SlotWidget widget : this.widgets) {
            widget.initialize();
        }
    }

    public Iterator listWidgets() {
        return this.widgets.iterator();
    }

    public void setAllMode(boolean allMode) {
        if (allMode != this.allMode) {
            this.allMode = allMode;
            if (allMode) {
                this.reinitAllPanel();
                this.add("Center", this.allPanel);
            } else {
                for (SlotWidget widget : this.widgets) {
                    WidgetHolder wc = (WidgetHolder)this.widgetContainers.get(widget);
                    this.tabbedPane.addTab(wc.tabName, (Component)widget);
                }
                this.add("Center", this.tabbedPane);
            }
        }
    }

    public void reinitAllPanel() {
        this.allPanel.removeAll();
        this.initAllPanel(this.allPanel, this.widgets);
    }

    public void setAssociatedCls(Cls cls) {
        super.setAssociatedCls(cls);
        for (SlotWidget slotWidget : this.widgets) {
            if (!(slotWidget instanceof AbstractSlotWidget)) continue;
            slotWidget.setAssociatedCls(cls);
        }
    }

    public void setBorder(Border border) {
        if (border instanceof EmptyBorder) {
            super.setBorder(null);
        } else {
            super.setBorder(border);
        }
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        for (SlotWidget slotWidget : this.widgets) {
            if (!(slotWidget instanceof AbstractSlotWidget)) continue;
            ((AbstractSlotWidget)slotWidget).setEditable(b);
        }
    }

    public void setInstance(Instance newInstance) {
        if (this.instance != null) {
            this.instance.removeFrameListener(this.valueListener);
        }
        for (SlotWidget widget : this.widgets) {
            widget.setInstance(newInstance);
        }
        this.instance = newInstance;
        if (this.instance != null) {
            this.instance.addFrameListener(this.valueListener);
        }
    }

    protected void setSelectedTab(Component tab) {
        this.tabbedPane.setSelectedComponent(tab);
    }

    public void setup(WidgetDescriptor descriptor, boolean isDesignTime, Project project, Cls cls, Slot slot) {
        super.setup(descriptor, isDesignTime, project, cls, slot);
        this.setupSubWidgets(slot, cls, isDesignTime, project);
    }

    protected void setupSubWidgets(Slot slot, Cls cls, boolean isDesignTime, Project project) {
        for (SlotWidget slotWidget : this.widgets) {
            WidgetHolder wc = (WidgetHolder)this.widgetContainers.get(slotWidget);
            String name = wc.slotName;
            Slot widgetSlot = name == null ? slot : this.getKnowledgeBase().getSlot(name);
            WidgetDescriptor neo = this.getPropertyList().getWidgetDescriptor(name);
            if (neo == null) {
                neo = this.createWidgetDescriptor(slotWidget, cls, widgetSlot);
            }
            slotWidget.setup(neo, isDesignTime, project, cls, widgetSlot);
        }
    }

    private class WidgetHolder {
        String slotName;
        String tabName;
        String widgetName;

        private WidgetHolder() {
        }
    }

    private class MultiWidgetConfigurationPanel
    extends WidgetConfigurationPanel {
        private List panels;

        MultiWidgetConfigurationPanel(MultiWidgetPropertyWidget widget) {
            super((SlotWidget)widget);
            this.panels = new ArrayList();
            this.getTabbedPane().removeAll();
            for (SlotWidget slotWidget : MultiWidgetPropertyWidget.this.widgets) {
                WidgetConfigurationPanel panel;
                if (!(slotWidget instanceof AbstractSlotWidget) || (panel = ((AbstractSlotWidget)slotWidget).createWidgetConfigurationPanel()) == null) continue;
                this.panels.add(panel);
                WidgetHolder holder = MultiWidgetPropertyWidget.this.getWidgetHolder(slotWidget);
                this.getTabbedPane().addTab(holder.tabName, (Component)panel);
            }
        }
    }
}

