/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.importstree;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.repository.impl.LocalFolderRepository;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.importstree.ImportsTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;

public class DownloadImportsAction
extends AbstractAction {
    private JFileChooser fileChooser = new JFileChooser();
    private ImportsTree tree;

    public DownloadImportsAction(ImportsTree tree) {
        super("Download ontologies to folder...", OWLIcons.getImageIcon("SaveInferred"));
        this.fileChooser.setFileSelectionMode(1);
        this.tree = tree;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.fileChooser.showDialog((Component)((Object)this.tree), "Download") == 0) {
            File folder = this.fileChooser.getSelectedFile();
            Set sels = this.tree.getSelectedResources();
            String message = "";
            int downloadedCount = 0;
            for (RDFResource resource : sels) {
                String uri = resource.getURI();
                try {
                    String fileName = DownloadImportsAction.download(uri, folder);
                    message = String.valueOf(message) + "Downloaded " + uri + "  to " + fileName + "\n";
                    ++downloadedCount;
                }
                catch (Exception ex) {
                    message = String.valueOf(message) + "Failed " + uri + "\n  " + ex.toString();
                }
            }
            OWLModel owlModel = this.tree.getRootOntology().getOWLModel();
            ProtegeUI.getModalDialogFactory().showMessageDialog(owlModel, message);
            if (downloadedCount > 0) {
                message = "Would you like to add a project repository to redirect imports to these local copies?";
                if (ProtegeUI.getModalDialogFactory().showConfirmDialog((Component)((Object)this.tree), message, "Add project repository?")) {
                    LocalFolderRepository rep = new LocalFolderRepository(folder);
                    owlModel.getRepositoryManager().addProjectRepository(0, rep);
                    ProtegeUI.getModalDialogFactory().showMessageDialog((Component)((Object)this.tree), "You should save and reload your project for the imports redirection to take effect.");
                }
            }
        }
    }

    public static String download(String uri, File targetFolder) throws Exception {
        InputStream is = null;
        try {
            int next;
            URL url = new URL(uri);
            int index = uri.lastIndexOf(47);
            if (index == uri.length() - 1) {
                index = uri.lastIndexOf(47, uri.length() - 2);
            }
            String fileName = uri.substring(index + 1);
            File file = new File(targetFolder, fileName);
            is = url.openStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            FileOutputStream fos = new FileOutputStream(file);
            while ((next = bis.read()) >= 0) {
                fos.write(next);
            }
            fos.close();
            String string = file.toString();
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

