/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.triplestore.impl;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreModel;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.AbstractAddPropertyValueHandler;
import edu.stanford.smi.protegex.owl.model.triplestore.impl.ProtegeTripleAdder;
import java.util.Collection;

class AddRDFTypePropertyHandler
extends AbstractAddPropertyValueHandler {
    private Slot directInstancesSlot;
    private Slot directTypesSlot;
    private Cls owlClassClass;
    private TripleStore tripleStore;
    private TripleStoreModel tripleStoreModel;
    private Cls untypedResourceClass;

    AddRDFTypePropertyHandler(ProtegeTripleAdder adder, KnowledgeBase kb, TripleStoreModel tripleStoreModel, TripleStore tripleStore) {
        super(adder);
        this.directInstancesSlot = kb.getSlot(":DIRECT-INSTANCES");
        this.directTypesSlot = kb.getSlot(":DIRECT-TYPE");
        this.owlClassClass = kb.getCls("owl:Class");
        this.untypedResourceClass = kb.getCls("protege:ExternalResource");
        this.tripleStoreModel = tripleStoreModel;
        this.tripleStore = tripleStore;
    }

    public void handleAdd(RDFResource subject, Object object) {
        Collection oldValues = this.adder.getSlotValues(subject, this.directTypesSlot);
        if (oldValues.isEmpty()) {
            this.tripleStoreModel.setHomeTripleStore(subject, this.tripleStore);
        }
        if (!object.equals(this.owlClassClass)) {
            if (this.adder.addValue(subject, this.directTypesSlot, object)) {
                this.adder.addValueFast((Instance)object, this.directInstancesSlot, subject);
            }
        } else if (oldValues.isEmpty() && this.adder.addValue(subject, this.directTypesSlot, object)) {
            this.adder.addValueFast((Instance)object, this.directInstancesSlot, subject);
        }
        if (oldValues.size() == 1 && oldValues.contains(this.untypedResourceClass)) {
            subject.removeDirectType(this.untypedResourceClass);
            this.tripleStoreModel.setHomeTripleStore(subject, this.tripleStore);
        }
    }
}

