/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.action.ConvertUnicodeSequenceAction;
import edu.stanford.smi.protege.action.InsertUnicodeCharacterAction;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.util.ApplicationProperties;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultListDragSourceListener;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protege.util.DoubleClickActionAdapter;
import edu.stanford.smi.protege.util.ExtensionFilter;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.LazyTreeRoot;
import edu.stanford.smi.protege.util.ListTarget;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SelectableList;
import edu.stanford.smi.protege.util.SelectableTable;
import edu.stanford.smi.protege.util.SelectableTree;
import edu.stanford.smi.protege.util.SimpleListModel;
import edu.stanford.smi.protege.util.StandardAction;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class ComponentFactory {
    public static final int STANDARD_BUTTON_HEIGHT = 25;
    public static final Dimension STANDARD_BUTTON_SIZE = new Dimension(25, 25);
    public static final int LARGE_BUTTON_HEIGHT = 33;
    public static final int STANDARD_FIELD_HEIGHT = 25;
    private static int _offset;
    private static final int OFFSET_SIZE = 25;
    private static final int MIN_LEFT_SPLIT_PANE_WIDTH;
    private static final String UNICODE_CHOOSER_CLASS = "com.catalysoft.swing.unicode.UnicodeChooser";

    private static int getMinLeftSplitPaneWidth() {
        String string = ComponentFactory.class.getName() + ".min_left_split_pane_width";
        String string2 = ApplicationProperties.getApplicationOrSystemProperty(string);
        int n = string2 == null ? 275 : Integer.parseInt(string2);
        return n;
    }

    public static void addMenuItem(JMenu jMenu, final Action action) {
        JMenuItem jMenuItem = new JMenuItem(action){

            public String getText() {
                String string = null;
                string = action == null ? super.getText() : (String)action.getValue("Name");
                return string;
            }

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }
        };
        jMenu.add(jMenuItem);
        jMenuItem.setDisabledIcon((Icon)action.getValue("SmallIcon"));
    }

    public static void addMenuItemNoIcon(JMenu jMenu, Action action) {
        ComponentFactory.addMenuItem(jMenu, action);
    }

    public static void addSubmenu(JMenu jMenu, JMenu jMenu2) {
        jMenu.add(jMenu2);
    }

    public static JToggleButton addToggleToolBarButton(JToolBar jToolBar, Action action) {
        return ComponentFactory.addToggleToolBarButton(jToolBar, action, 25);
    }

    public static JToggleButton addLargeToggleToolBarButton(JToolBar jToolBar, Action action) {
        return ComponentFactory.addToggleToolBarButton(jToolBar, action, 33);
    }

    public static JToggleButton addToggleToolBarButton(JToolBar jToolBar, Action action, int n) {
        JToggleButton jToggleButton = new JToggleButton(action);
        jToggleButton.setToolTipText((String)action.getValue("Name"));
        ComponentFactory.addToolBarButton(jToolBar, action, jToggleButton);
        return jToggleButton;
    }

    public static void addToolBarButton(JToolBar jToolBar, Action action, AbstractButton abstractButton) {
        abstractButton.setText(null);
        jToolBar.add(abstractButton);
    }

    public static JButton addToolBarButton(JToolBar jToolBar, Action action) {
        return ComponentFactory.addToolBarButton(jToolBar, action, 25);
    }

    public static JButton addLargeToolBarButton(JToolBar jToolBar, Action action) {
        return ComponentFactory.addToolBarButton(jToolBar, action, 33);
    }

    public static JButton addToolBarButton(JToolBar jToolBar, Action action, int n) {
        JButton jButton = new JButton(action);
        ComponentFactory.addButton(jToolBar, action, jButton, n);
        return jButton;
    }

    private static void addButton(JToolBar jToolBar, Action action, AbstractButton abstractButton, int n) {
        abstractButton.setText(null);
        abstractButton.setToolTipText(StandardAction.getName(action));
        abstractButton.setOpaque(false);
        abstractButton.setRolloverEnabled(true);
        abstractButton.setMnemonic(0);
        action.putValue("protege.component", abstractButton);
        Dimension dimension = new Dimension();
        dimension.width = dimension.height = n;
        abstractButton.setSize(dimension);
        abstractButton.setPreferredSize(dimension);
        abstractButton.setMinimumSize(dimension);
        abstractButton.setMaximumSize(dimension);
        abstractButton.setDisabledIcon((Icon)action.getValue("DisabledSmallIcon"));
        if (abstractButton.getIcon() == null) {
            abstractButton.setIcon(Icons.getUglyIcon());
        }
        jToolBar.add(abstractButton);
    }

    private static void adjustPosition(Component component) {
        _offset = (_offset + 1) % 4;
        Point point = component.getLocation();
        point.x += _offset * 25;
        point.y += _offset * 25;
        component.setLocation(point);
    }

    private static Dimension buttonPreferredHeightSize(Dimension dimension) {
        dimension.height = Math.max(25, dimension.height);
        return dimension;
    }

    private static int getHeight(Component component) {
        return component.getFontMetrics(component.getFont()).getHeight() + 4;
    }

    private static void configureList(JList jList, Action action, boolean bl) {
        jList.setModel(new SimpleListModel());
        if (action != null) {
            jList.addMouseListener(new DoubleClickActionAdapter(action));
        }
        if (bl) {
            ComponentFactory.setupDragAndDrop(jList);
            ComponentUtilities.setDragAndDropEnabled(jList, bl);
        }
        jList.setCellRenderer(new DefaultRenderer());
        jList.setFixedCellHeight(ComponentFactory.getHeight(jList));
    }

    public static void configureTable(JTable jTable) {
        jTable.setRowHeight(ComponentFactory.getHeight(jTable));
    }

    public static void configureTree(JTree jTree, Action action) {
        if (action != null) {
            jTree.addMouseListener(new DoubleClickActionAdapter(action));
        }
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(false);
        jTree.setRowHeight(ComponentFactory.getHeight(jTree));
    }

    public static JButton createButton(Action action) {
        JButton jButton = new JButton(action);
        return jButton;
    }

    public static JCheckBox createCheckBox() {
        return ComponentFactory.createCheckBox("");
    }

    public static JCheckBox createCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(string){

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }
        };
        return jCheckBox;
    }

    public static JComboBox createComboBox() {
        JComboBox jComboBox = new JComboBox(){

            public Dimension getPreferredSize() {
                return ComponentFactory.fieldPreferredHeightSize(super.getPreferredSize());
            }

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }
        };
        return jComboBox;
    }

    public static JFileChooser createFileChooser(String string, String string2) {
        return ComponentFactory.createFileChooser(string, null, string2);
    }

    public static JFileChooser createFileChooser(String string, String string2, String string3) {
        File file = ApplicationProperties.getLastFileDirectory();
        JFileChooser jFileChooser = new JFileChooser(file){

            public int showDialog(Component component, String string) {
                int n = super.showDialog(component, string);
                if (n == 0) {
                    ApplicationProperties.setLastFileDirectory(this.getCurrentDirectory());
                }
                return n;
            }
        };
        jFileChooser.setDialogTitle(string);
        if (string3 == null) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            String string4 = string2;
            jFileChooser.setFileFilter(new ExtensionFilter(string3, string4));
        }
        return jFileChooser;
    }

    public static JFrame createMainFrame() {
        JFrame jFrame = new JFrame();
        ComponentFactory.initializeFrame(jFrame);
        return jFrame;
    }

    public static JFrame createFrame() {
        DisposableFrame disposableFrame = new DisposableFrame();
        ComponentFactory.initializeFrame(disposableFrame);
        return disposableFrame;
    }

    private static void initializeFrame(JFrame jFrame) {
        jFrame.setDefaultCloseOperation(0);
        Image image = ((ImageIcon)Icons.getLogoIcon()).getImage();
        jFrame.setIconImage(image);
    }

    public static JLabel createLabel() {
        JLabel jLabel = new JLabel(){

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }
        };
        return jLabel;
    }

    public static JLabel createLabel(String string) {
        JLabel jLabel = ComponentFactory.createLabel();
        jLabel.setText(string);
        return jLabel;
    }

    public static JLabel createLabel(Icon icon) {
        JLabel jLabel = ComponentFactory.createLabel();
        jLabel.setIcon(icon);
        return jLabel;
    }

    public static JLabel createLabel(Icon icon, int n) {
        JLabel jLabel = ComponentFactory.createLabel(icon);
        jLabel.setHorizontalAlignment(n);
        return jLabel;
    }

    public static JLabel createLabel(String string, int n) {
        JLabel jLabel = ComponentFactory.createLabel(string);
        jLabel.setHorizontalAlignment(n);
        return jLabel;
    }

    public static JLabel createLabel(String string, Icon icon, int n) {
        JLabel jLabel = ComponentFactory.createLabel(icon, n);
        jLabel.setText(string);
        return jLabel;
    }

    public static LabeledComponent createLabeledScrollComponent(String string, JComponent jComponent, Dimension dimension) {
        LabeledComponent labeledComponent = new LabeledComponent(string, ComponentFactory.createScrollPane(jComponent));
        if (dimension != null) {
            labeledComponent.setPreferredSize(dimension);
        }
        return labeledComponent;
    }

    public static LabeledComponent createLabeledScrollComponent(String string, JComponent jComponent, Dimension dimension, JComponent jComponent2, Collection collection, JComponent jComponent3) {
        LabeledComponent labeledComponent = ComponentFactory.createLabeledScrollComponent(string, jComponent, dimension);
        if (jComponent2 != null) {
            labeledComponent.setHeaderComponent(jComponent2);
        }
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (iterator == null) continue;
                Action action = (Action)iterator.next();
                labeledComponent.addHeaderButton(action);
            }
        }
        if (jComponent3 != null) {
            labeledComponent.setFooterComponent(jComponent3);
        }
        return labeledComponent;
    }

    public static JSplitPane createLeftRightSplitPane() {
        return ComponentFactory.createLeftRightSplitPane(true);
    }

    public static JSplitPane createLeftRightSplitPane(boolean bl) {
        JSplitPane jSplitPane = ComponentFactory.createSplitPane(1, bl, 0.0);
        jSplitPane.setOneTouchExpandable(true);
        return jSplitPane;
    }

    public static JSplitPane createLeftRightSplitPane(Component component, Component component2) {
        return ComponentFactory.createLeftRightSplitPane(component, component2, true);
    }

    public static JSplitPane createLeftRightSplitPane(Component component, Component component2, boolean bl) {
        JSplitPane jSplitPane = ComponentFactory.createLeftRightSplitPane(bl);
        jSplitPane.setLeftComponent(component);
        jSplitPane.setRightComponent(component2);
        return jSplitPane;
    }

    public static JList createList(Action action) {
        return ComponentFactory.createList(action, false);
    }

    public static JList createList(Action action, boolean bl) {
        return ComponentFactory.createSelectableList(action, bl);
    }

    public static JMenuItem createMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string){

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }
        };
        return jMenuItem;
    }

    public static JMenu createMenu() {
        JMenu jMenu = new JMenu();
        return jMenu;
    }

    public static JMenu createMenu(String string) {
        JMenu jMenu = ComponentFactory.createMenu();
        jMenu.setText(string);
        return jMenu;
    }

    public static JMenu createMenu(ResourceKey resourceKey) {
        JMenu jMenu = ComponentFactory.createMenu();
        jMenu.setText(LocalizedText.getText(resourceKey));
        jMenu.setMnemonic(LocalizedText.getMnemonic(resourceKey));
        return jMenu;
    }

    public static JMenu createMenu(String string, int n) {
        JMenu jMenu = ComponentFactory.createMenu(string);
        jMenu.setMnemonic(n);
        return jMenu;
    }

    public static JPanel createPanel() {
        JPanel jPanel = new JPanel();
        return jPanel;
    }

    public static JPasswordField createPasswordField() {
        JPasswordField jPasswordField = new JPasswordField(){

            public Dimension getPreferredSize() {
                return ComponentFactory.fieldPreferredHeightSize(super.getPreferredSize());
            }
        };
        return jPasswordField;
    }

    public static JRadioButton createRadioButton(String string) {
        return new JRadioButton(string);
    }

    public static JRadioButton createRadioButton(Action action) {
        return new JRadioButton(action);
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(Action action) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
        ComponentFactory.initializeAbstractButton(jRadioButtonMenuItem, action);
        return jRadioButtonMenuItem;
    }

    public static JCheckBoxMenuItem createCheckBoxMenuItem(Action action, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(action);
        jCheckBoxMenuItem.setSelected(bl);
        ComponentFactory.initializeAbstractButton(jCheckBoxMenuItem, action);
        return jCheckBoxMenuItem;
    }

    public static JCheckBoxMenuItem addCheckBoxMenuItem(JMenu jMenu, Action action, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = ComponentFactory.createCheckBoxMenuItem(action, bl);
        jMenu.add(jCheckBoxMenuItem);
        return jCheckBoxMenuItem;
    }

    public static JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        return jScrollPane;
    }

    public static JScrollPane createScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        return jScrollPane;
    }

    public static JScrollPane createScrollPane(JTable jTable) {
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.getViewport().setBackground(jTable.getBackground());
        return jScrollPane;
    }

    public static SelectableList createSelectableList(Action action) {
        return ComponentFactory.createSelectableList(action, false);
    }

    public static SelectableList createSelectableList(Action action, boolean bl) {
        SelectableList selectableList = new SelectableList();
        ComponentFactory.configureList(selectableList, action, bl);
        return selectableList;
    }

    public static SelectableTable createSelectableTable(Action action) {
        SelectableTable selectableTable = new SelectableTable();
        if (action != null) {
            selectableTable.addMouseListener(new DoubleClickActionAdapter(action));
        }
        selectableTable.setShowGrid(false);
        selectableTable.setIntercellSpacing(new Dimension(0, 0));
        selectableTable.setColumnSelectionAllowed(false);
        selectableTable.setAutoResizeMode(3);
        selectableTable.setAutoCreateColumnsFromModel(false);
        selectableTable.setDefaultEditor(Object.class, null);
        return selectableTable;
    }

    public static SelectableTree createSelectableTree(Action action) {
        return ComponentFactory.createSelectableTree(action, null);
    }

    public static SelectableTree createSelectableTree(Action action, LazyTreeRoot lazyTreeRoot) {
        SelectableTree selectableTree = new SelectableTree(action, lazyTreeRoot);
        return selectableTree;
    }

    public static SelectableList createSingleItemList(Action action) {
        SelectableList selectableList = (SelectableList)ComponentFactory.createList(action);
        selectableList.setPreferredSize(new Dimension(1, 25));
        selectableList.setFixedCellHeight(21);
        selectableList.setBorder(BorderFactory.createEtchedBorder());
        return selectableList;
    }

    private static void setSplitPaneComponentMinimumSize(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setMinimumSize(new Dimension(0, 0));
        }
    }

    private static JSplitPane createSplitPane(int n, boolean bl, double d) {
        JSplitPane jSplitPane = new JSplitPane(n, bl){
            private boolean initialized;

            public void addImpl(Component component, Object object, int n) {
                super.addImpl(component, object, n);
                ComponentFactory.setSplitPaneComponentMinimumSize(component);
            }

            public void reshape(int n, int n2, int n3, int n4) {
                super.reshape(n, n2, n3, n4);
                if (!this.initialized && n3 != 0 && n4 != 0) {
                    this.initialized = true;
                    if (this.getOrientation() == 0) {
                        int n5 = this.getHeight() - this.getBottomComponent().getPreferredSize().height;
                        this.setDividerLocation(n5);
                    } else {
                        int n6 = this.getLeftComponent().getPreferredSize().width;
                        n6 = Math.max(n6, MIN_LEFT_SPLIT_PANE_WIDTH);
                        this.setDividerLocation(n6);
                    }
                }
            }
        };
        jSplitPane.setBorder(null);
        jSplitPane.setResizeWeight(d);
        return jSplitPane;
    }

    public static Border createStandardBorder() {
        return BorderFactory.createEmptyBorder(5, 5, 5, 5);
    }

    public static Border createThinStandardBorder() {
        return BorderFactory.createEmptyBorder(3, 3, 3, 3);
    }

    public static JTabbedPane createTabbedPane(final boolean bl) {
        JTabbedPane jTabbedPane = new JTabbedPane(){

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }

            public void addImpl(Component component, Object object, int n) {
                if (bl) {
                    JComponent jComponent = (JComponent)component;
                    jComponent.setBorder(BorderFactory.createCompoundBorder(ComponentFactory.createThinStandardBorder(), jComponent.getBorder()));
                }
                super.addImpl(component, object, n);
            }
        };
        return jTabbedPane;
    }

    public static JTable createTable(Action action) {
        return ComponentFactory.createSelectableTable(action);
    }

    public static JTextArea createTextArea() {
        JTextArea jTextArea = new JTextArea(){

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }

            public void setText(String string) {
                super.setText(string);
                this.setCaretPosition(0);
                this.repaint();
            }
        };
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        ComponentFactory.configureTextComponent(jTextArea);
        return jTextArea;
    }

    public static JTextField createTextField(String string) {
        JTextField jTextField = ComponentFactory.createTextField();
        jTextField.setText(string);
        return jTextField;
    }

    public static JTextField createTextField() {
        JTextField jTextField = new JTextField(){

            public void paint(Graphics graphics) {
                ComponentUtilities.enableTextAntialiasing(graphics);
                super.paint(graphics);
            }

            public Dimension getPreferredSize() {
                return ComponentFactory.fieldPreferredHeightSize(super.getPreferredSize());
            }
        };
        ComponentFactory.configureTextComponent(jTextField);
        return jTextField;
    }

    private static void configureTextComponent(JTextComponent jTextComponent) {
        ComponentFactory.addAction(jTextComponent, 88, 8, new ConvertUnicodeSequenceAction());
        if (SystemUtilities.forName(UNICODE_CHOOSER_CLASS) != null) {
            ComponentFactory.addAction(jTextComponent, 73, 8, new InsertUnicodeCharacterAction());
        }
    }

    private static void addAction(JTextComponent jTextComponent, int n, int n2, Action action) {
        Keymap keymap = jTextComponent.getKeymap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, n2);
        keymap.addActionForKeyStroke(keyStroke, action);
    }

    public static JTextPane createTextPane() {
        JTextPane jTextPane = new JTextPane();
        return jTextPane;
    }

    public static JToggleButton createToggleButton(Action action) {
        JToggleButton jToggleButton = new JToggleButton(){

            public Dimension getPreferredSize() {
                return ComponentFactory.buttonPreferredHeightSize(super.getPreferredSize());
            }
        };
        ComponentFactory.initializeAbstractButton(jToggleButton, action);
        return jToggleButton;
    }

    public static JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = 25;
                return dimension;
            }
        };
        jToolBar.setOpaque(false);
        jToolBar.setRollover(true);
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setBorder(null);
        return jToolBar;
    }

    public static JSplitPane createTopBottomSplitPane(boolean bl) {
        return ComponentFactory.createSplitPane(0, bl, 1.0);
    }

    public static JSplitPane createTopBottomSplitPane() {
        return ComponentFactory.createTopBottomSplitPane(true);
    }

    public static JSplitPane createTopBottomSplitPane(Component component, Component component2) {
        return ComponentFactory.createTopBottomSplitPane(component, component2, true);
    }

    public static JSplitPane createTopBottomSplitPane(Component component, Component component2, boolean bl) {
        JSplitPane jSplitPane = ComponentFactory.createTopBottomSplitPane(bl);
        jSplitPane.setTopComponent(component);
        jSplitPane.setBottomComponent(component2);
        return jSplitPane;
    }

    public static JTree createTree(Action action) {
        return ComponentFactory.createSelectableTree(action);
    }

    public static JWindow createWindow() {
        JWindow jWindow = new JWindow();
        return jWindow;
    }

    private static Dimension fieldPreferredHeightSize(Dimension dimension) {
        dimension.height = 25;
        return dimension;
    }

    public static JComponent getCloseButtonPanel(final JFrame jFrame) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JButton jButton = ComponentFactory.createButton(new AbstractAction("Close", Icons.getCloseIcon()){

            public void actionPerformed(ActionEvent actionEvent) {
                ComponentUtilities.closeWindow(jFrame);
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private static void initializeAbstractButton(final AbstractButton abstractButton, final Action action) {
        action.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                abstractButton.setEnabled(action.isEnabled());
            }
        });
        abstractButton.setEnabled(action.isEnabled());
        abstractButton.addActionListener(action);
        abstractButton.setIcon((Icon)action.getValue("SmallIcon"));
        abstractButton.setAlignmentX(0.5f);
        abstractButton.setAlignmentY(0.5f);
        abstractButton.setText((String)action.getValue("Name"));
        abstractButton.setToolTipText((String)action.getValue("ShortDescription"));
        abstractButton.setHorizontalTextPosition(4);
    }

    private static void setupDragAndDrop(JList jList) {
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(jList, 3, new DefaultListDragSourceListener());
        new DropTarget(jList, 3, new ListTarget());
    }

    public static JFrame showInFrame(Component component, String string) {
        JFrame jFrame = ComponentFactory.createFrame();
        jFrame.setDefaultCloseOperation(2);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add(component, "Center");
        container.add((Component)ComponentFactory.getCloseButtonPanel(jFrame), "South");
        jFrame.pack();
        jFrame.setTitle(string);
        ComponentUtilities.center(jFrame);
        ComponentFactory.adjustPosition(jFrame);
        jFrame.setVisible(true);
        return jFrame;
    }

    public static JEditorPane createEditorPane() {
        return new JEditorPane();
    }

    public static JEditorPane createHTMLBrowser(URL uRL) {
        JEditorPane jEditorPane = new JEditorPane(){

            public void paint(Graphics graphics) {
                ComponentUtilities.enableAllAntialiasing(graphics);
                super.paint(graphics);
            }
        };
        jEditorPane.setEditable(false);
        jEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    SystemUtilities.showHTML(hyperlinkEvent.getURL().toString());
                }
            }
        });
        if (uRL != null) {
            ComponentFactory.setPage(jEditorPane, uRL);
        }
        return jEditorPane;
    }

    public static void setPage(JEditorPane jEditorPane, URL uRL) {
        try {
            jEditorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            Log.getLogger().warning(iOException.toString());
        }
    }

    public static JLabel createSmallFontLabel(String string) {
        JLabel jLabel = ComponentFactory.createLabel(string);
        ComponentUtilities.setSmallLabelFont(jLabel);
        return jLabel;
    }

    public static JLabel createTitleFontLabel(String string) {
        JLabel jLabel = ComponentFactory.createLabel(string);
        ComponentUtilities.setTitleLabelFont(jLabel);
        return jLabel;
    }

    static {
        MIN_LEFT_SPLIT_PANE_WIDTH = ComponentFactory.getMinLeftSplitPaneWidth();
    }

    private static class DisposableFrame
    extends JFrame
    implements Disposable {
        DisposableFrame() {
            ComponentUtilities.registerWindow(this);
            this.enableEvents(64L);
        }

        public void processWindowEvent(WindowEvent windowEvent) {
            if (windowEvent.getID() == 202) {
                ComponentUtilities.deregisterWindow(this);
            }
            super.processWindowEvent(windowEvent);
        }
    }
}

