/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Union;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestUnion
extends GraphTestBase {
    public TestUnion(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestUnion.class);
    }

    public void testUnion() {
        Graph graph = TestUnion.graphWith("x R y; p R q");
        Graph graph2 = TestUnion.graphWith("r A s; x R y");
        Union union = new Union(graph, graph2);
        TestUnion.assertContains("Union", "x R y", union);
        TestUnion.assertContains("Union", "p R q", union);
        TestUnion.assertContains("Union", "r A s", union);
        if (union.size() != 3) {
            TestUnion.fail((String)"oops: size of union is not 3");
        }
        union.add(TestUnion.triple("cats eat cheese"));
        TestUnion.assertContains("Union", "cats eat cheese", union);
        if (!TestUnion.contains(graph, "cats eat cheese") && !TestUnion.contains(graph2, "cats eat cheese")) {
            TestUnion.fail((String)"oops: neither g1 nor g2 contains `cats eat cheese`");
        }
    }
}

