/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.rdf.model.test.RecordingModelListener;
import java.io.StringReader;
import junit.framework.TestSuite;

public class TestReaderEvents
extends ModelTestBase {
    public TestReaderEvents(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestReaderEvents.class);
    }

    public void testXMLReaderEvents() {
        String string = "<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'></rdf:RDF>";
        this.testReaderEvent("RDF/XML", string);
    }

    public void testN3ReaderEvents() {
        this.testReaderEvent("N3", "");
    }

    public void testNTriplesReaderEvents() {
        this.testReaderEvent("N-TRIPLE", "");
    }

    public void testReaderEvent(String string, String string2) {
        Model model = ModelFactory.createDefaultModel();
        RecordingModelListener recordingModelListener = new RecordingModelListener();
        model.register(recordingModelListener);
        RDFReader rDFReader = model.getReader(string);
        StringReader stringReader = new StringReader(string2);
        rDFReader.read(model, stringReader, "");
        recordingModelListener.assertHasStart(new Object[]{"someEvent", model, GraphEvents.startRead});
        recordingModelListener.assertHasEnd(new Object[]{"someEvent", model, GraphEvents.finishRead});
    }
}

