/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;

public abstract class CharEncoding {
    static Set macEncodings = new HashSet();
    private String name;

    private CharEncoding() {
    }

    private CharEncoding(String string) {
        this.name = string;
    }

    public String name() {
        return this.name;
    }

    public abstract boolean isIANA();

    public abstract boolean isInNIO();

    public abstract String warningMessage();

    public static CharEncoding create(String string) {
        if (Charset.isSupported(string)) {
            String string2 = Charset.forName(string).name();
            if (string2.charAt(1) == '-' && (string2.charAt(0) == 'x' || string2.charAt(0) == 'X')) {
                return new NonIANAnioEncoding(string2);
            }
            if (string2.startsWith("Mac") && macEncodings.contains(string2)) {
                return new NonIANAnioEncoding(string2);
            }
            return new IANAnioEncoding(string2);
        }
        return new NotNioEncoding(string);
    }

    static {
        macEncodings.add("MacArabic");
        macEncodings.add("MacCentralEurope");
        macEncodings.add("MacCroatian");
        macEncodings.add("MacCyrillic");
        macEncodings.add("MacDingbat");
        macEncodings.add("MacGreek");
        macEncodings.add("MacHebrew");
        macEncodings.add("MacIceland");
        macEncodings.add("MacRoman");
        macEncodings.add("MacRomania");
        macEncodings.add("MacSymbol");
        macEncodings.add("MacThai");
        macEncodings.add("MacTurkish");
        macEncodings.add("MacUkraine");
    }

    private static class NotNioEncoding
    extends CharEncoding {
        NotNioEncoding(String string) {
            super(string);
        }

        public boolean isIANA() {
            return false;
        }

        public boolean isInNIO() {
            return false;
        }

        public String warningMessage() {
            return "The encoding \"" + this.name() + "\" is not fully supported; maybe try using Java 1.5 or higher (if you are not already).";
        }
    }

    private static class NonIANAnioEncoding
    extends CharEncoding {
        NonIANAnioEncoding(String string) {
            super(string);
        }

        public boolean isIANA() {
            return false;
        }

        public boolean isInNIO() {
            return true;
        }

        public String warningMessage() {
            return "The encoding \"" + this.name() + "\" is not registered with IANA, and hence not suitable for Web content.";
        }
    }

    private static class IANAnioEncoding
    extends CharEncoding {
        IANAnioEncoding(String string) {
            super(string);
        }

        public boolean isIANA() {
            return true;
        }

        public boolean isInNIO() {
            return true;
        }

        public String warningMessage() {
            return null;
        }
    }
}

