/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.iterator.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.ResourceUtils;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.TestCase;

public class TestResourceUtils
extends TestCase {
    public static final String NS = "http://jena.hp.com/test#";

    public TestResourceUtils(String string) {
        super(string);
    }

    public void testMaximalLowerElements() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hp.com/test#a");
        Resource resource2 = model.createResource("http://jena.hp.com/test#b");
        Resource resource3 = model.createResource("http://jena.hp.com/test#c");
        Resource resource4 = model.createResource("http://jena.hp.com/test#d");
        resource2.addProperty(RDFS.subClassOf, resource);
        resource3.addProperty(RDFS.subClassOf, resource);
        resource4.addProperty(RDFS.subClassOf, resource3);
        resource4.addProperty(RDFS.subClassOf, resource);
        List<Object> list = Arrays.asList(resource, resource2, resource3, resource4);
        List<Object> list2 = Arrays.asList(resource2, resource3, resource4);
        List<Object> list3 = Arrays.asList(resource3, resource4);
        TestResourceUtils.assertEquals((String)"Wrong number of remaining resources", (int)1, (int)ResourceUtils.maximalLowerElements(list, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals((String)"Result should be a", (Object)resource, ResourceUtils.maximalLowerElements(list, RDFS.subClassOf, true).iterator().next());
        TestResourceUtils.assertEquals((String)"Wrong number of remaining resources", (int)2, (int)ResourceUtils.maximalLowerElements(list2, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals((String)"Wrong number of remaining resources", (int)1, (int)ResourceUtils.maximalLowerElements(list3, RDFS.subClassOf, true).size());
        TestResourceUtils.assertEquals((String)"Result should be a", (Object)resource3, ResourceUtils.maximalLowerElements(list3, RDFS.subClassOf, true).iterator().next());
    }

    public void testRenameResource() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hp.com/test#a");
        Resource resource2 = model.createResource("http://jena.hp.com/test#b");
        Resource resource3 = model.createResource("http://jena.hp.com/test#c");
        Resource resource4 = model.createResource("http://jena.hp.com/test#d");
        Property property = model.createProperty(NS, "p");
        Property property2 = model.createProperty(NS, "q");
        resource.addProperty(property, resource2);
        resource.addProperty(property2, resource3);
        resource4.addProperty(property, resource);
        resource4.addProperty(property, resource2);
        Resource resource5 = ResourceUtils.renameResource(resource, "http://jena.hp.com/test#e");
        TestResourceUtils.assertTrue((String)"should be no properties of a", (!resource.listProperties().hasNext() ? (byte)1 : 0) != 0);
        TestResourceUtils.assertEquals((String)"uri of a", (String)"http://jena.hp.com/test#a", (String)resource.getURI());
        TestResourceUtils.assertEquals((String)"uri of e", (String)"http://jena.hp.com/test#e", (String)resource5.getURI());
        TestResourceUtils.assertTrue((String)"d should not have p a", (!resource4.hasProperty(property, resource) ? (byte)1 : 0) != 0);
        TestResourceUtils.assertTrue((String)"d should have p e", (boolean)resource4.hasProperty(property, resource5));
        TestResourceUtils.assertTrue((String)"e should have p b", (boolean)resource5.hasProperty(property, resource2));
        TestResourceUtils.assertTrue((String)"e should have q c", (boolean)resource5.hasProperty(property2, resource3));
        TestResourceUtils.assertTrue((String)"d p b should be unchanged", (boolean)resource4.hasProperty(property, resource2));
        Resource resource6 = ResourceUtils.renameResource(resource5, null);
        TestResourceUtils.assertTrue((String)"should be no properties of e", (!resource5.listProperties().hasNext() ? (byte)1 : 0) != 0);
        TestResourceUtils.assertEquals((String)"uri of e", (String)"http://jena.hp.com/test#e", (String)resource5.getURI());
        TestResourceUtils.assertTrue((String)"anon", (boolean)resource6.isAnon());
        TestResourceUtils.assertTrue((String)"d should not have p e", (!resource4.hasProperty(property, resource5) ? (byte)1 : 0) != 0);
        TestResourceUtils.assertTrue((String)"d should have p anon", (boolean)resource4.hasProperty(property, resource6));
        TestResourceUtils.assertTrue((String)"anon should have p b", (boolean)resource6.hasProperty(property, resource2));
        TestResourceUtils.assertTrue((String)"anon should have q c", (boolean)resource6.hasProperty(property2, resource3));
        TestResourceUtils.assertTrue((String)"d p b should be unchanged", (boolean)resource4.hasProperty(property, resource2));
        Resource resource7 = model.createResource("http://jena.hp.com/test#f");
        resource7.addProperty(property, resource7);
        Resource resource8 = ResourceUtils.renameResource(resource7, "http://jena.hp.com/test#f1");
        TestResourceUtils.assertFalse((String)"Should be no f statements", (boolean)model.listStatements(resource7, null, (RDFNode)null).hasNext());
        TestResourceUtils.assertTrue((String)"f1 has p f1", (boolean)resource8.hasProperty(property, resource8));
    }

    public void testReachableGraphClosure() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("a");
        Resource resource2 = model.createResource("b");
        Resource resource3 = model.createResource("c");
        Resource resource4 = model.createResource("d");
        Property property = model.createProperty("p");
        model.add(resource, property, resource2);
        model.add(resource, property, resource3);
        model.add(resource2, property, resource2);
        model.add(resource2, property, resource);
        model.add(resource4, property, resource);
        Model model2 = ModelFactory.createDefaultModel();
        model2.add(resource, property, resource2);
        model2.add(resource, property, resource3);
        model2.add(resource2, property, resource2);
        model2.add(resource2, property, resource);
        TestResourceUtils.assertTrue((String)"m1 should be isomorphic with the reachable sub-graph from a", (boolean)model2.isIsomorphicWith(ResourceUtils.reachableClosure(resource)));
    }

    public void testRemoveEquiv() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hp.com/test#a");
        Resource resource2 = model.createResource("http://jena.hp.com/test#b");
        Resource resource3 = model.createResource("http://jena.hp.com/test#c");
        Resource resource4 = model.createResource("http://jena.hp.com/test#d");
        Resource resource5 = model.createResource("http://jena.hp.com/test#e");
        resource2.addProperty(RDFS.subClassOf, resource);
        resource.addProperty(RDFS.subClassOf, resource2);
        resource4.addProperty(RDFS.subClassOf, resource5);
        resource5.addProperty(RDFS.subClassOf, resource4);
        resource.addProperty(RDFS.subClassOf, resource);
        resource2.addProperty(RDFS.subClassOf, resource2);
        resource3.addProperty(RDFS.subClassOf, resource3);
        resource4.addProperty(RDFS.subClassOf, resource4);
        resource5.addProperty(RDFS.subClassOf, resource5);
        List<Object> list = Arrays.asList(resource, resource2, resource3, resource4, resource5);
        List<Object> list2 = Arrays.asList(resource, resource2);
        List<Object> list3 = Arrays.asList(resource3, resource4, resource5);
        List<Object> list4 = Arrays.asList(resource, resource2, resource4, resource5);
        List<Object> list5 = Arrays.asList(resource4, resource5);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(list);
        List list6 = null;
        TestResourceUtils.assertTrue((boolean)((Object)arrayList).equals(list));
        TestResourceUtils.assertFalse((boolean)((Object)arrayList).equals(list3));
        TestResourceUtils.assertNull(list6);
        list6 = ResourceUtils.removeEquiv(arrayList, RDFS.subClassOf, resource);
        TestResourceUtils.assertFalse((boolean)((Object)arrayList).equals(list));
        TestResourceUtils.assertTrue((boolean)((Object)arrayList).equals(list3));
        TestResourceUtils.assertNotNull((Object)list6);
        TestResourceUtils.assertEquals((Object)list6, list2);
        list6 = ResourceUtils.removeEquiv(arrayList, RDFS.subClassOf, resource5);
        TestResourceUtils.assertFalse((boolean)((Object)arrayList).equals(list));
        TestResourceUtils.assertTrue((boolean)((Object)arrayList).equals(Collections.singletonList(resource3)));
        TestResourceUtils.assertNotNull((Object)list6);
        TestResourceUtils.assertEquals((Object)list6, list5);
    }

    public void testPartition() {
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource("http://jena.hp.com/test#a");
        Resource resource2 = model.createResource("http://jena.hp.com/test#b");
        Resource resource3 = model.createResource("http://jena.hp.com/test#c");
        Resource resource4 = model.createResource("http://jena.hp.com/test#d");
        Resource resource5 = model.createResource("http://jena.hp.com/test#e");
        resource2.addProperty(RDFS.subClassOf, resource);
        resource.addProperty(RDFS.subClassOf, resource2);
        resource4.addProperty(RDFS.subClassOf, resource5);
        resource5.addProperty(RDFS.subClassOf, resource4);
        resource.addProperty(RDFS.subClassOf, resource);
        resource2.addProperty(RDFS.subClassOf, resource2);
        resource3.addProperty(RDFS.subClassOf, resource3);
        resource4.addProperty(RDFS.subClassOf, resource4);
        resource5.addProperty(RDFS.subClassOf, resource5);
        List<Object> list = Arrays.asList(resource, resource2, resource3, resource4, resource5);
        List<Object> list2 = Arrays.asList(resource2, resource);
        List<Object> list3 = Arrays.asList(resource3);
        List<Object> list4 = Arrays.asList(resource5, resource4);
        List list5 = ResourceUtils.partition(list, RDFS.subClassOf);
        TestResourceUtils.assertEquals((String)"Should be 3 partitions", (int)3, (int)list5.size());
        TestResourceUtils.assertEquals((String)"First parition should be (a,b)", list2, list5.get(0));
        TestResourceUtils.assertEquals((String)"First parition should be (c)", list3, list5.get(1));
        TestResourceUtils.assertEquals((String)"First parition should be (d,e)", list4, list5.get(2));
    }
}

