/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger;

import edu.stanford.smi.protegex.owl.inference.dig.exception.DIGError;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.DIGReasoner;
import edu.stanford.smi.protegex.owl.inference.dig.reasoner.logger.DIGLoggerListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class DIGLogger {
    private static Map loggerMap = new WeakHashMap();
    private ArrayList listeners = new ArrayList();

    private DIGLogger() {
    }

    public static DIGLogger getInstance(DIGReasoner digReasoner) {
        DIGLogger instance = (DIGLogger)loggerMap.get(digReasoner);
        if (instance == null) {
            instance = new DIGLogger();
            loggerMap.put(digReasoner, instance);
        }
        return instance;
    }

    public void logError(DIGError error) {
        Iterator it = new ArrayList(this.listeners).iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            if (ref.get() == null) {
                it.remove();
                continue;
            }
            ((DIGLoggerListener)it.next()).errorLogged(error);
        }
    }

    public void addListener(DIGLoggerListener listener) {
        this.listeners.add(new WeakReference<DIGLoggerListener>(listener));
    }

    public void removeListener(DIGLoggerListener listener) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            if (ref.get() == null) {
                it.remove();
                continue;
            }
            if (ref.get() != listener) continue;
            it.remove();
        }
    }
}

