/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.storage.tests;

import com.hp.hpl.jena.ontology.OntProperty;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBaseFactory;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.jena.JenaKnowledgeBaseFactory;
import edu.stanford.smi.protegex.owl.jena.JenaOWLModel;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.storage.OWL2OWLCopier;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class OWL2OWLCopierTestCase
extends AbstractJenaTestCase {
    private JenaOWLModel runCopier() {
        ArrayList errors = new ArrayList();
        this.project = new Project(null, errors);
        JenaKnowledgeBaseFactory factory = new JenaKnowledgeBaseFactory();
        this.project.setKnowledgeBaseFactory((KnowledgeBaseFactory)factory);
        this.project.createDomainKnowledgeBase((KnowledgeBaseFactory)factory, errors, false);
        JenaOWLModel target = (JenaOWLModel)this.project.getKnowledgeBase();
        new OWL2OWLCopier(this.owlModel, target).run();
        return target;
    }

    public void testEnumeration() {
        OWLNamedClass cls = this.owlModel.createOWLNamedClass("Degree");
        RDFResource ms = cls.createInstance("MS");
        RDFResource ma = cls.createInstance("MA");
        OWLEnumeratedClass enumerationCls = this.owlModel.createOWLEnumeratedClass(Arrays.asList(ms, ma));
        OWLObjectProperty slot = this.owlModel.createOWLObjectProperty("slot");
        OWLSomeValuesFrom restriction = this.owlModel.createOWLSomeValuesFrom((RDFProperty)slot, enumerationCls);
        OWLNamedClass studentCls = this.owlModel.createOWLNamedClass("Student");
        OWLNamedClass graduateStudentCls = this.owlModel.createOWLNamedSubclass("GraduateStudent", studentCls);
        graduateStudentCls.addSuperclass(restriction);
        JenaOWLModel target = this.runCopier();
        Instance newMS = target.getInstance(ms.getName());
        OWL2OWLCopierTestCase.assertEquals((int)1, (int)newMS.getDirectTypes().size());
        OWL2OWLCopierTestCase.assertSize(1, (Iterator)target.getOntModel().listEnumeratedClasses());
    }

    public void testEquivalentClass() {
        OWLNamedClass genderCls = this.owlModel.createOWLNamedClass("Gender");
        RDFResource male = genderCls.createInstance("male");
        OWLObjectProperty genderSlot = this.owlModel.createOWLObjectProperty("gender");
        OWLNamedClass maleCls = this.owlModel.createOWLNamedClass("Male");
        OWLHasValue hasRestriction = this.owlModel.createOWLHasValue(genderSlot, male);
        maleCls.setDefinition(hasRestriction);
        JenaOWLModel target = this.runCopier();
        OWL2OWLCopierTestCase.assertSize(1, (Iterator)target.getOntModel().listRestrictions());
    }

    public void testInverseSlots() {
        OWLObjectProperty aSlot = this.owlModel.createOWLObjectProperty("A");
        OWLObjectProperty bSlot = this.owlModel.createOWLObjectProperty("B");
        aSlot.setInverseProperty(bSlot);
        JenaOWLModel target = this.runCopier();
        OWLObjectProperty newASlot = (OWLObjectProperty)target.getSlot(aSlot.getName());
        OWLObjectProperty newBSlot = (OWLObjectProperty)target.getSlot(bSlot.getName());
        OWL2OWLCopierTestCase.assertNotNull((Object)newASlot.getInverseProperty());
        OWL2OWLCopierTestCase.assertEquals((Object)newASlot.getInverseProperty(), (Object)newBSlot);
        OntProperty aProperty = target.getOntModel().getOntProperty(newASlot.getURI());
        OntProperty bProperty = target.getOntModel().getOntProperty(newBSlot.getURI());
        OWL2OWLCopierTestCase.assertSize(1, (Iterator)aProperty.listInverseOf());
        OWL2OWLCopierTestCase.assertEquals((Object)aProperty, (Object)bProperty.getInverseOf());
        OWL2OWLCopierTestCase.assertSize(1, (Iterator)bProperty.listInverseOf());
        OWL2OWLCopierTestCase.assertEquals((Object)bProperty, (Object)aProperty.getInverseOf());
    }

    public void testNamespaces() {
        String DEFAULT = "http://aldi.de/ont#";
        this.owlModel.getNamespaceManager().setDefaultNamespace("http://aldi.de/ont#");
        String TEST = "http://test.de/ont#";
        this.owlModel.getNamespaceManager().setPrefix("http://test.de/ont#", "test");
        JenaOWLModel target = this.runCopier();
        OWL2OWLCopierTestCase.assertEquals((String)"http://test.de/ont#", (String)target.getNamespaceManager().getNamespaceForPrefix("test"));
        OWL2OWLCopierTestCase.assertEquals((String)"http://aldi.de/ont#", (String)target.getNamespaceManager().getDefaultNamespace());
    }
}

