/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.testing.sanity;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.AbstractOWLTest;
import edu.stanford.smi.protegex.owl.testing.DefaultOWLTestResult;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RDFPropertyTest;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class InversePropertyMustHaveMatchingRangeAndDomainTest
extends AbstractOWLTest
implements RepairableOWLTest,
RDFPropertyTest {
    public InversePropertyMustHaveMatchingRangeAndDomainTest() {
        super("Sanity Tests", null);
    }

    private static boolean equalCollections(Collection a, Collection b) {
        return a.containsAll(b) && b.containsAll(a);
    }

    public static boolean fails(RDFProperty property) {
        if (property instanceof OWLObjectProperty && ((OWLObjectProperty)property).getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty inverseSlot = (OWLObjectProperty)property.getInverseProperty();
            if (!property.isDomainDefined() || !inverseSlot.isDomainDefined()) {
                return false;
            }
            Collection domain = property.getUnionDomain();
            Collection range = property.getUnionRangeClasses();
            Collection inverseDomain = inverseSlot.getUnionDomain();
            Collection inverseRange = inverseSlot.getUnionRangeClasses();
            return !InversePropertyMustHaveMatchingRangeAndDomainTest.equalCollections(domain, inverseRange) || !InversePropertyMustHaveMatchingRangeAndDomainTest.equalCollections(range, inverseDomain);
        }
        return false;
    }

    public boolean repair(OWLTestResult testResult) {
        OWLProperty property = (OWLProperty)testResult.getHost();
        if (InversePropertyMustHaveMatchingRangeAndDomainTest.fails(property) && property instanceof OWLObjectProperty && ((OWLObjectProperty)property).getInverseProperty() instanceof OWLObjectProperty) {
            OWLObjectProperty inverseSlot = (OWLObjectProperty)property.getInverseProperty();
            if (property.isDomainDefined() && inverseSlot.isDomainDefined()) {
                Collection inverseDomain = inverseSlot.getUnionDomain();
                Collection inverseRange = inverseSlot.getUnionRangeClasses();
                property.setUnionRangeClasses(inverseDomain);
                ArrayList oldDomain = new ArrayList(property.getUnionDomain());
                for (OWLNamedClass namedCls : oldDomain) {
                    property.removeUnionDomainClass(namedCls);
                }
                for (RDFSClass cls : inverseRange) {
                    property.addUnionDomainClass(cls);
                }
            }
        }
        return !InversePropertyMustHaveMatchingRangeAndDomainTest.fails(property);
    }

    public List test(RDFProperty property) {
        if (InversePropertyMustHaveMatchingRangeAndDomainTest.fails(property)) {
            return Collections.singletonList(new DefaultOWLTestResult("Inverse properties must have inverse domains and ranges.", property, 1, this));
        }
        return Collections.EMPTY_LIST;
    }
}

