/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protege.Application;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTable;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import java.awt.Component;
import java.util.Collection;

public class AddNamedClassAction
extends ResourceSelectionAction {
    private PropertyFormTable table;

    public AddNamedClassAction(PropertyFormTable table) {
        super("Add named class...", OWLIcons.getAddIcon("PrimitiveClass"));
        this.table = table;
    }

    public Collection getSelectableResources() {
        OWLModel owlModel = this.table.getTableModel().getProperty().getOWLModel();
        Collection col = owlModel.getUserDefinedOWLNamedClasses();
        col.removeAll(this.table.getTableModel().getRDFResources());
        return col;
    }

    public void resourceSelected(RDFResource resource) {
        RDFProperty prop = this.table.getTableModel().getProperty();
        OWLNamedClass subject = this.table.getTableModel().getNamedClass();
        OWLSomeValuesFrom someRestr = subject.getOWLModel().createOWLSomeValuesFrom(prop, resource);
        subject.addSuperclass(someRestr);
    }

    public RDFResource pickResource() {
        RDFProperty prop = this.table.getTableModel().getProperty();
        Collection ranges = prop.getRanges(true);
        OWLModel owlModel = prop.getOWLModel();
        Component mainWindow = Application.getMainWindow();
        return ProtegeUI.getSelectionDialogFactory().selectClass(mainWindow, owlModel, ranges);
    }
}

