/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.cls;

import edu.stanford.smi.protege.action.ViewClsAction;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.resource.LocalizedText;
import edu.stanford.smi.protege.resource.ResourceKey;
import edu.stanford.smi.protege.ui.HeaderComponent;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.DefaultRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectableContainer;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.cls.ClassTreePanel;
import edu.stanford.smi.protegex.owl.ui.cls.CreateSiblingClassAction;
import edu.stanford.smi.protegex.owl.ui.cls.CreateSubclassAction;
import edu.stanford.smi.protegex.owl.ui.cls.DeleteClassAction;
import edu.stanford.smi.protegex.owl.ui.cls.Hierarchy;
import edu.stanford.smi.protegex.owl.ui.cls.HierarchyManager;
import edu.stanford.smi.protegex.owl.ui.cls.OWLSubclassPane;
import edu.stanford.smi.protegex.owl.ui.cls.ToggleSuperclassExplorerAction;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialAction;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.matrix.cls.ClassMatrixAction;
import edu.stanford.smi.protegex.owl.ui.profiles.OWLProfiles;
import edu.stanford.smi.protegex.owl.ui.profiles.ProfilesManager;
import edu.stanford.smi.protegex.owl.ui.subsumption.HiddenClassesPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.InferredSubsumptionTreePanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;

public class AssertedClassesPanel
extends SelectableContainer
implements Hierarchy,
ClassTreePanel {
    protected HeaderComponent classBrowserHeader;
    private Action createSiblingClassAction = new AbstractAction("Create sibling class", OWLIcons.getCreateIcon("SiblingClass")){

        public void actionPerformed(ActionEvent e) {
            AssertedClassesPanel.this.createSibling();
        }
    };
    private Action createSubClassAction = new AbstractAction("Create subclass", OWLIcons.getCreateIcon("SubClass", 4)){

        public void actionPerformed(ActionEvent e) {
            AssertedClassesPanel.this.createSubclass();
        }
    };
    protected AllowableAction deleteAction;
    private ExistentialAction existentialAction;
    private HeaderComponent headerComponent;
    private HierarchyManager hierarchyManager;
    protected LabeledComponent labeledComponent;
    private OWLModel owlModel;
    protected OWLSubclassPane subclassPane;
    protected Action viewAction;

    public AssertedClassesPanel(Project project, HierarchyManager hierarchyManager) {
        this((OWLModel)project.getKnowledgeBase(), hierarchyManager);
    }

    public AssertedClassesPanel(OWLModel owlModel, HierarchyManager hierarchyManager) {
        this.owlModel = owlModel;
        this.viewAction = this.getViewClassAction();
        this.deleteAction = this.getDeleteClsAction();
        this.createPanes();
        this.labeledComponent = new OWLLabeledComponent(this.getTitle(), (Component)((Object)this.subclassPane), true, false);
        this.labeledComponent.setBorder(ComponentUtilities.getAlignBorder());
        this.add((Component)this.labeledComponent, "Center");
        this.add((Component)this.createClsBrowserHeader(), "North");
        this.setSelectable((Selectable)this.subclassPane);
        this.updateDeleteActionState();
        this.hierarchyManager = hierarchyManager;
        this.labeledComponent.addHeaderButton(this.createSubClassAction);
        this.labeledComponent.addHeaderButton(this.createSiblingClassAction);
        this.createSiblingClassAction.setEnabled(false);
        this.labeledComponent.addHeaderButton((Action)this.deleteAction);
        this.existentialAction = new ExistentialAction((Component)((Object)this), hierarchyManager, null);
        this.existentialAction.setEnabled(false);
        if (ProfilesManager.isFeatureSupported(owlModel, OWLProfiles.OWL_DL)) {
            JButton existButton = this.subclassPane.getFinder().addButton(this.existentialAction);
            this.existentialAction.activateComboBox(existButton);
            AbstractAction showInferredAction = new AbstractAction("Explore inferred hierarchy", OWLIcons.getImageIcon("ShowInferred")){

                public void actionPerformed(ActionEvent e) {
                    AssertedClassesPanel.this.showInferred();
                }
            };
            this.subclassPane.getFinder().addButton(showInferredAction);
        }
    }

    protected OWLSubclassPane createSubclassPane(Action viewAction, RDFSNamedClass rootClass, Action createClsAction, Action deleteClsAction) {
        return this.createSubclassPane(viewAction, rootClass, deleteClsAction);
    }

    protected OWLSubclassPane createSubclassPane(Action viewAction, RDFSNamedClass rootClass, Action deleteClsAction) {
        this.subclassPane = new OWLSubclassPane(this.owlModel, viewAction, rootClass);
        this.subclassPane.setHierarchyManager(this.hierarchyManager);
        this.subclassPane.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent event) {
                if (AssertedClassesPanel.this.subclassPane.getSelection().size() == 1) {
                    Cls cls = (Cls)AssertedClassesPanel.this.subclassPane.getSelection().iterator().next();
                    AssertedClassesPanel.this.createSiblingClassAction.setEnabled(!AssertedClassesPanel.this.owlModel.getOWLThingClass().equals(cls));
                    if (cls instanceof OWLNamedClass) {
                        AssertedClassesPanel.this.existentialAction.setEnabled(true);
                        AssertedClassesPanel.this.existentialAction.setCls((OWLNamedClass)cls);
                    } else {
                        AssertedClassesPanel.this.existentialAction.setEnabled(false);
                    }
                }
            }
        });
        this.subclassPane.getFinder().addButton(new ClassMatrixAction(this.owlModel));
        this.subclassPane.getFinder().addButton(new ToggleSuperclassExplorerAction(this, false));
        return this.subclassPane;
    }

    public Hierarchy createClone() {
        AssertedClassesPanel panel = new AssertedClassesPanel(this.owlModel, this.hierarchyManager);
        panel.getLabeledComponent().removeHeaderButton(this.getLabeledComponent().getHeaderButtons().size() - 1);
        panel.getLabeledComponent().removeHeaderButton(this.getLabeledComponent().getHeaderButtons().size() - 1);
        return panel;
    }

    protected HeaderComponent createClsBrowserHeader() {
        JLabel label = ComponentFactory.createLabel((String)this.owlModel.getProject().getName(), (Icon)Icons.getProjectIcon(), (int)2);
        String forProject = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_FOR_PROJECT_LABEL);
        String classBrowser = LocalizedText.getText((ResourceKey)ResourceKey.CLASS_BROWSER_TITLE);
        this.headerComponent = new HeaderComponent(classBrowser, forProject, (JComponent)label);
        return this.headerComponent;
    }

    private void createSibling() {
        Collection siblings = this.subclassPane.getSelection();
        if (siblings.size() == 1) {
            RDFSNamedClass sibling = (RDFSNamedClass)siblings.iterator().next();
            CreateSiblingClassAction.performAction(sibling, this);
        }
    }

    private void createSubclass() {
        Collection parents = this.subclassPane.getSelection();
        if (!parents.isEmpty()) {
            CreateSubclassAction.performAction(parents, this);
        }
    }

    protected void createPanes() {
        this.subclassPane = this.createSubclassPane(this.viewAction, this.owlModel.getOWLThingClass(), (Action)this.deleteAction);
    }

    public JTree getClsesTree() {
        return (JTree)this.subclassPane.getDropComponent();
    }

    protected AllowableAction getDeleteClsAction() {
        return new AllowableDeleteAction(this);
    }

    protected JComponent getDisplayedComponent() {
        return (JComponent)this.labeledComponent.getCenterComponent();
    }

    public JComponent getDropComponent() {
        return this.subclassPane.getDropComponent();
    }

    public HeaderComponent getHeaderComponent() {
        return this.headerComponent;
    }

    public LabeledComponent getLabeledComponent() {
        return this.labeledComponent;
    }

    public Project getProject() {
        return this.owlModel.getProject();
    }

    public Collection getSelection() {
        return ((Selectable)this.getDisplayedComponent()).getSelection();
    }

    public RDFSClass getSelectedClass() {
        Collection sels = this.subclassPane.getSelection();
        if (sels.isEmpty()) {
            return null;
        }
        return (RDFSClass)sels.iterator().next();
    }

    public String getTitle() {
        return "Asserted Hierarchy";
    }

    public JTree getTree() {
        return this.getClsesTree();
    }

    public String getType() {
        return "Subclass Explorer";
    }

    private Action getViewClassAction() {
        return new ViewClsAction(this){

            public void onView(Object o) {
                AssertedClassesPanel.this.showInstance((Instance)((Cls)o));
            }
        };
    }

    public boolean isDefaultSynchronized() {
        return false;
    }

    public void navigateToResource(RDFResource resource) {
        if (resource instanceof RDFSNamedClass) {
            this.setSelectedClass((RDFSNamedClass)resource);
        }
    }

    public void setExpandedCls(Cls cls, boolean expanded) {
        if (cls instanceof RDFSNamedClass) {
            this.setExpandedClass((RDFSNamedClass)cls, expanded);
        }
    }

    public void setExpandedClass(RDFSNamedClass cls, boolean expanded) {
        this.subclassPane.setExpandedCls(cls, expanded);
    }

    public void setFinderComponent(JComponent c) {
        this.subclassPane.setFinderComponent(c);
    }

    public void setRenderer(DefaultRenderer renderer) {
        this.subclassPane.setRenderer(renderer);
    }

    public void setSelectedClass(RDFSClass cls) {
        this.subclassPane.setSelectedClass(cls);
    }

    public void setSelectedCls(Cls cls) {
        this.setSelectedClass((RDFSClass)cls);
    }

    public void showInferred() {
        InferredSubsumptionTreePanel inferredTreePanel = new InferredSubsumptionTreePanel(this.owlModel);
        this.hierarchyManager.addHierarchy(inferredTreePanel);
    }

    public void showHidden() {
        HiddenClassesPanel hiddenTreePanel = new HiddenClassesPanel(this.owlModel);
        this.hierarchyManager.addHierarchy(hiddenTreePanel);
    }

    protected void showInstance(Instance instance) {
        this.owlModel.getProject().show(instance);
    }

    protected void updateDeleteActionState() {
        if (this.deleteAction != null) {
            this.deleteAction.onSelectionChange();
        }
    }

    private class AllowableDeleteAction
    extends AllowableAction {
        public AllowableDeleteAction(Selectable selectable) {
            super("Delete selected class(es)", OWLIcons.getDeleteClsIcon(), selectable);
        }

        public void actionPerformed(ActionEvent e) {
            DeleteClassAction.performAction(this.getSelection(), (ClassTreePanel)AssertedClassesPanel.this);
        }

        public void onSelectionChange() {
            boolean isEditable = true;
            for (Frame frame : this.getSelection()) {
                if (frame.isEditable()) continue;
                isEditable = false;
                break;
            }
            this.setAllowed(isEditable);
        }
    }
}

