/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.clsproperties;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.resourceselection.ResourceSelectionAction;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.PropertyWidget;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;

public class AddPropertyAction
extends ResourceSelectionAction {
    private PropertyWidget propertyWidget;

    public AddPropertyAction(PropertyWidget propertyWidget) {
        super("Add this class to the domain of properties...", OWLIcons.getAddIcon("RDFProperty"), true);
        this.propertyWidget = propertyWidget;
    }

    public void resourceSelected(RDFResource resource) {
        RDFSClass cls = (RDFSClass)this.propertyWidget.getEditedResource();
        RDFProperty property = (RDFProperty)resource;
        OWLNamedClass rootCls = cls.getOWLModel().getOWLThingClass();
        OWLModel owlModel = resource.getOWLModel();
        try {
            try {
                owlModel.beginTransaction("Add " + cls.getBrowserText() + " to the domain of " + property.getBrowserText());
                if (property.getUnionDomain(false).contains(rootCls)) {
                    property.removeUnionDomainClass(rootCls);
                }
                property.addUnionDomainClass(cls);
                property.synchronizeDomainAndRangeOfInverse();
            }
            catch (Exception ex) {
                OWLUI.handleError(owlModel, ex);
            }
        }
        finally {
            owlModel.endTransaction();
        }
    }

    protected RDFSNamedClass getBasePropertyMetaclass() {
        OWLModel owlModel = (OWLModel)this.propertyWidget.getKnowledgeBase();
        return owlModel.getRDFPropertyClass();
    }

    public Collection getSelectableResources() {
        RDFSNamedClass propertyMetaclass = this.getBasePropertyMetaclass();
        ArrayList properties = new ArrayList(propertyMetaclass.getInstances(true));
        RDFSClass cls = (RDFSClass)this.propertyWidget.getEditedResource();
        properties.removeAll(cls.getUnionDomainProperties());
        ArrayList<RDFProperty> choice = new ArrayList<RDFProperty>();
        for (RDFProperty property : properties) {
            if (property instanceof OWLProperty && property.isAnnotationProperty() || !property.isEditable()) continue;
            choice.add(property);
        }
        return choice;
    }

    public Collection pickResources() {
        String label = "Select " + this.propertyWidget.getLabel();
        OWLModel owlModel = (OWLModel)this.propertyWidget.getKnowledgeBase();
        return ProtegeUI.getSelectionDialogFactory().selectResourcesFromCollection((Component)((Object)this.propertyWidget), owlModel, this.getSelectableResources(), label);
    }
}

