/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.existential;

import edu.stanford.smi.protege.event.FrameAdapter;
import edu.stanford.smi.protege.event.FrameEvent;
import edu.stanford.smi.protege.event.FrameListener;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.LazyTreeNodeFrameComparator;
import edu.stanford.smi.protege.util.LazyTreeNode;
import edu.stanford.smi.protegex.owl.model.OWLClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.ui.existential.ExistentialFillerProvider;
import java.util.Collection;
import java.util.Comparator;

public class ExistentialTreeNode
extends LazyTreeNode {
    private ExistentialFillerProvider fillerProvider;
    private FrameListener frameListener = new FrameAdapter(){

        public void browserTextChanged(FrameEvent event) {
            ExistentialTreeNode.this.notifyNodeChanged();
        }

        public void ownSlotValueChanged(FrameEvent event) {
            ExistentialTreeNode.this.notifyNodeChanged();
            if (event.getSlot().equals(ExistentialTreeNode.this.superclassesSlot)) {
                ExistentialTreeNode.this.reload();
            }
        }

        public void visibilityChanged(FrameEvent event) {
            ExistentialTreeNode.this.notifyNodeChanged();
        }
    };
    private Slot superclassesSlot;
    private OWLObjectProperty existentialProperty;

    public ExistentialTreeNode(LazyTreeNode parentNode, OWLClass parentCls, Slot superclassesSlot, OWLObjectProperty existentialProperty) {
        super(parentNode, (Object)parentCls);
        this.fillerProvider = new ExistentialFillerProvider(existentialProperty);
        parentCls.accept(this.fillerProvider);
        this.superclassesSlot = superclassesSlot;
        this.existentialProperty = existentialProperty;
        parentCls.addFrameListener(this.frameListener);
    }

    protected LazyTreeNode createNode(Object o) {
        return new ExistentialTreeNode(this, (OWLClass)o, this.superclassesSlot, this.existentialProperty);
    }

    protected void dispose() {
        super.dispose();
        this.getOWLClass().removeFrameListener(this.frameListener);
    }

    protected int getChildObjectCount() {
        return this.fillerProvider.getFillers().size();
    }

    protected Collection getChildObjects() {
        return this.fillerProvider.getFillers();
    }

    public OWLClass getOWLClass() {
        return (OWLClass)this.getUserObject();
    }

    public void reload() {
        this.fillerProvider.reset();
        this.getOWLClass().accept(this.fillerProvider);
        super.reload();
    }

    protected Comparator getComparator() {
        return new LazyTreeNodeFrameComparator();
    }

    protected void notifyNodeChanged() {
        this.notifyNodeChanged(this);
    }

    public String toString() {
        return "ExistentialTreeNode(" + this.getOWLClass() + ")";
    }
}

