/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFResourceCollectionContentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.rdfwriter.RDFXMLDocumentWriter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterFactory;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriterNamespaceManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;

public class RDFResourceCollectionWriter {
    private RDFResourceCollectionContentWriter collectionContentWriter;
    private boolean enclose;
    private XMLWriter xmlWriter;

    public RDFResourceCollectionWriter(OWLModel model, TripleStore tripleStore, Collection resources, Writer writer, boolean encloseInRDFElement) {
        String ontologyName = Util.getOntologyName(model, tripleStore);
        XMLWriterNamespaceManager nsm = Util.getNamespacePrefixes(model.getNamespaceManager(), model.getNamespaceManager().getDefaultNamespace());
        this.xmlWriter = XMLWriterFactory.getInstance().createXMLWriter(writer, nsm, ontologyName);
        this.enclose = encloseInRDFElement;
        this.collectionContentWriter = new RDFResourceCollectionContentWriter(resources, tripleStore);
    }

    public RDFResourceCollectionWriter(OWLModel model, TripleStore tripleStore, Collection resources, XMLWriter xmlWriter, boolean encloseInRDFElement) {
        this.xmlWriter = xmlWriter;
        this.enclose = encloseInRDFElement;
        this.collectionContentWriter = new RDFResourceCollectionContentWriter(resources, tripleStore);
    }

    public void write() throws IOException {
        if (this.enclose) {
            RDFXMLDocumentWriter docWriter = new RDFXMLDocumentWriter(this.xmlWriter, Collections.singleton(this.collectionContentWriter));
            docWriter.writeDocument();
        } else {
            this.collectionContentWriter.writeContent(this.xmlWriter);
        }
    }
}

