/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.parser.rdql;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.parser.rdql.Expr;
import com.hp.hpl.jena.query.parser.rdql.ExprNode;
import com.hp.hpl.jena.query.parser.rdql.NodeValue;
import com.hp.hpl.jena.query.parser.rdql.RDQLParser;
import com.hp.hpl.jena.query.parser.rdql.WorkingVar;
import com.hp.hpl.jena.query.util.IndentedWriter;
import org.apache.commons.logging.LogFactory;

public class Q_Var
extends ExprNode
implements Expr {
    String varName;
    int index;

    public Q_Var(int n) {
        super(n);
    }

    public Q_Var(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void jjtClose() {
    }

    public void setName(String string) {
        if (string.startsWith("?")) {
            string = string.substring(1);
        }
        this.varName = string;
    }

    public NodeValue eval(Query query2, IndexValues indexValues) {
        Node node = (Node)indexValues.get(this.index);
        if (node == null) {
            LogFactory.getLog((Class)Q_Var.class).warn((Object)("Unbound variable: " + this.varName));
            WorkingVar workingVar = new WorkingVar();
            workingVar.setString("unset: " + this.varName + "/" + this.index);
            return workingVar;
        }
        WorkingVar workingVar = new WorkingVar();
        workingVar.setNode(node);
        return workingVar;
    }

    public String toString() {
        return "?" + this.varName;
    }

    public String asInfixString() {
        return this.toString();
    }

    public String asPrefixString() {
        return this.toString();
    }

    public void format(IndentedWriter indentedWriter) {
        indentedWriter.print(this.asPrefixString());
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        this.index = variableIndexes.indexOf(this.varName);
        return this;
    }

    public boolean isVariable() {
        return true;
    }

    public String getName() {
        return this.varName;
    }
}

