/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.inference.util;

import edu.stanford.smi.protege.event.ProjectAdapter;
import edu.stanford.smi.protege.event.ProjectEvent;
import edu.stanford.smi.protege.event.ProjectListener;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class ReasonerUtil {
    private static ReasonerUtil instance;
    private HashMap namedClsesMap;
    private HashMap propertiesMap;
    private HashMap individualsMap;
    private ProjectListener projectListener = new ProjectAdapter(){

        public void projectClosed(ProjectEvent event) {
            Project project = (Project)event.getSource();
            project.removeProjectListener(ReasonerUtil.this.projectListener);
            ((OWLModel)project.getKnowledgeBase()).removeModelListener(ReasonerUtil.this.modelListener);
            ReasonerUtil.this.initHashMaps();
        }
    };
    private ModelListener modelListener = new ModelAdapter(){

        public void classCreated(RDFSClass cls) {
            ReasonerUtil.this.invalidateNamedClsCache(cls.getOWLModel());
        }

        public void classDeleted(RDFSClass cls) {
            ReasonerUtil.this.invalidateNamedClsCache(cls.getOWLModel());
        }

        public void propertyCreated(RDFProperty property) {
            ReasonerUtil.this.invalidatePropertiesCache(property.getOWLModel());
        }

        public void propertyDeleted(RDFProperty property) {
            ReasonerUtil.this.invalidatePropertiesCache(property.getOWLModel());
        }

        public void individualCreated(RDFResource resource) {
            ReasonerUtil.this.invalidateIndividualsCache(resource.getOWLModel());
        }

        public void individualDeleted(RDFResource resource) {
            ReasonerUtil.this.invalidateIndividualsCache(resource.getOWLModel());
        }
    };
    private long lastClassificationTime;

    protected ReasonerUtil() {
        this.initHashMaps();
        this.lastClassificationTime = 0L;
    }

    public static synchronized ReasonerUtil getInstance() {
        if (instance == null) {
            instance = new ReasonerUtil();
        }
        return instance;
    }

    private void initHashMaps() {
        this.namedClsesMap = new HashMap();
        this.propertiesMap = new HashMap();
        this.individualsMap = new HashMap();
    }

    public Collection getNamedClses(OWLModel kb) {
        Collection namedClses;
        if (!this.namedClsesMap.containsKey(kb)) {
            this.namedClsesMap.put(kb, kb.getUserDefinedOWLNamedClasses());
            kb.addModelListener(this.modelListener);
            kb.getProject().addProjectListener(this.projectListener);
        }
        if ((namedClses = (Collection)this.namedClsesMap.get(kb)) == null) {
            namedClses = kb.getUserDefinedOWLNamedClasses();
            this.namedClsesMap.put(kb, namedClses);
        }
        return namedClses;
    }

    public Collection getProperties(OWLModel kb) {
        Collection properties;
        if (!this.propertiesMap.containsKey(kb)) {
            this.propertiesMap.put(kb, kb.getUserDefinedOWLProperties());
            kb.addModelListener(this.modelListener);
        }
        if ((properties = (Collection)this.propertiesMap.get(kb)) == null) {
            properties = kb.getUserDefinedOWLProperties();
            this.propertiesMap.put(kb, properties);
        }
        return properties;
    }

    public Collection getIndividuals(OWLModel kb) {
        Collection individuals;
        if (!this.individualsMap.containsKey(kb)) {
            this.individualsMap.put(kb, this.getOWLIndividuals(kb));
            kb.addModelListener(this.modelListener);
        }
        if ((individuals = (Collection)this.individualsMap.get(kb)) == null) {
            individuals = this.getOWLIndividuals(kb);
            this.individualsMap.put(kb, individuals);
        }
        return individuals;
    }

    private Collection getOWLIndividuals(OWLModel model) {
        IndividualsFilter filter = new IndividualsFilter(model);
        return filter.getOWLIndividuals();
    }

    public void invalidateNamedClsCache(OWLModel kb) {
        this.namedClsesMap.put(kb, null);
    }

    public void invalidatePropertiesCache(OWLModel kb) {
        this.propertiesMap.put(kb, null);
    }

    public void invalidateIndividualsCache(OWLModel kb) {
        this.individualsMap.put(kb, null);
    }

    public long getLastClassificationTime() {
        return this.lastClassificationTime;
    }

    public void setLastClassificationTime() {
        this.lastClassificationTime = System.currentTimeMillis();
    }

    public OWLNamedClass getNamedReferent(OWLAnonymousClass cls) {
        OWLAnonymousClass newExpRoot;
        OWLAnonymousClass expRoot = cls.getExpressionRoot();
        while ((newExpRoot = expRoot.getExpressionRoot()) != expRoot) {
            expRoot = newExpRoot;
        }
        OWLNamedClass namedCls = null;
        Iterator subclsIt = cls.getNamedSubclasses().iterator();
        if (subclsIt.hasNext()) {
            namedCls = (OWLNamedClass)subclsIt.next();
        }
        return namedCls;
    }

    private class IndividualsFilter
    extends OWLModelVisitorAdapter {
        private Collection individuals;
        private OWLModel model;

        public IndividualsFilter(OWLModel model) {
            this.model = model;
        }

        public Collection getOWLIndividuals() {
            this.individuals = new ArrayList();
            for (RDFResource curRes : this.model.getRDFResources()) {
                curRes.accept(this);
            }
            return this.individuals;
        }

        public void visitOWLIndividual(OWLIndividual owlIndividual) {
            this.individuals.add(owlIndividual);
        }
    }
}

