/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.creator.tests;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.jena.creator.tests.AbstractJenaCreatorTestCase;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import java.net.URI;
import java.util.Iterator;

public class CreateRDFLiteralValuesTestCase
extends AbstractJenaCreatorTestCase {
    public void testRDFValueInRDFLiteral() throws Exception {
        this.loadTestOntology(new URI("http://www.daml.org/2004/04/swrl/swrl.owl"));
        OWLNamedClass datavaluedPropertyAtomCls = (OWLNamedClass)this.owlModel.getCls("swrl:DatavaluedPropertyAtom");
        CreateRDFLiteralValuesTestCase.assertNotNull((Object)datavaluedPropertyAtomCls);
        RDFProperty argument2Property = (RDFProperty)this.owlModel.getSlot("swrl:argument2");
        CreateRDFLiteralValuesTestCase.assertNotNull((Object)argument2Property);
        RDFResource atom = datavaluedPropertyAtomCls.createInstance("atom");
        Cls literalCls = this.owlModel.getCls("rdfs:Literal");
        Instance literal = literalCls.createDirectInstance("myLiteral");
        Slot valueSlot = this.owlModel.getSlot("rdf:value");
        String value = "aldi";
        literal.setDirectOwnSlotValue(valueSlot, (Object)"aldi");
        atom.addPropertyValue(argument2Property, literal);
    }

    public void testValuesOfImportedProperties() throws Exception {
        this.loadRemoteOntology("importSWRL.owl");
        OWLNamedClass datavaluedPropertyAtomCls = (OWLNamedClass)this.owlModel.getCls("swrl:DatavaluedPropertyAtom");
        CreateRDFLiteralValuesTestCase.assertNotNull((Object)datavaluedPropertyAtomCls);
        RDFProperty argument2RDFProperty = (RDFProperty)this.owlModel.getSlot("swrl:argument2");
        CreateRDFLiteralValuesTestCase.assertNotNull((Object)argument2RDFProperty);
        RDFResource atom = datavaluedPropertyAtomCls.createInstance("atom");
        atom.addPropertyValue(argument2RDFProperty, "aldi");
        OntModel newModel = this.runJenaCreator();
        Resource atomResource = newModel.getResource(atom.getURI());
        CreateRDFLiteralValuesTestCase.assertNotNull((Object)atomResource);
        Property argument2OntProperty = newModel.getProperty(argument2RDFProperty.getURI());
        CreateRDFLiteralValuesTestCase.assertNotNull((Object)argument2OntProperty);
        CreateRDFLiteralValuesTestCase.assertSize(1, (Iterator)atomResource.listProperties(argument2OntProperty));
    }
}

