/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.parser.tests;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.tests.AbstractJenaTestCase;
import java.net.URI;

public class LoadRDFListTestCase
extends AbstractJenaTestCase {
    public void testLoadSWRLOld() throws Exception {
        this.loadTestOntology(new URI("http://www.daml.org/2003/11/swrl/swrl.owl"));
    }

    public void testLoadSubClassOfList() throws Exception {
        this.loadRemoteOntology("list-example.owl");
        OWLNamedClass personListCls = this.owlModel.getOWLNamedClass("PersonList");
        LoadRDFListTestCase.assertNotNull((Object)personListCls);
        LoadRDFListTestCase.assertEquals((int)5, (int)personListCls.getInstanceCount(false));
        for (Instance instance : personListCls.getInstances(false)) {
            LoadRDFListTestCase.assertTrue((boolean)(instance instanceof RDFList));
        }
        Slot personsSlot = this.owlModel.getSlot("persons");
        LoadRDFListTestCase.assertNotNull((Object)personsSlot);
        Instance myRanking = this.owlModel.getInstance("MyRanking");
        LoadRDFListTestCase.assertNotNull((Object)myRanking);
        RDFList head = (RDFList)myRanking.getDirectOwnSlotValue(personsSlot);
        LoadRDFListTestCase.assertNotNull((Object)head);
        Instance first = this.owlModel.getInstance("FirstPerson");
        LoadRDFListTestCase.assertNotNull((Object)first);
        LoadRDFListTestCase.assertEquals((Object)first, (Object)head.getFirst());
    }

    public void testLoadPetList() throws Exception {
        this.loadRemoteOntology("randy.owl");
        Instance randy = this.owlModel.getInstance("Randy");
        Slot petsSlot = this.owlModel.getSlot("pets");
        RDFList li = (RDFList)randy.getDirectOwnSlotValue(petsSlot);
        LoadRDFListTestCase.assertSize(3, li.getValues());
    }
}

