/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFObject;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParseException;
import edu.stanford.smi.protegex.owl.model.classparser.OWLClassParser;
import edu.stanford.smi.protegex.owl.model.impl.AbstractOWLRestriction;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitor;
import java.util.Set;

public class DefaultOWLHasValue
extends AbstractOWLRestriction
implements OWLHasValue {
    public static final char OPERATOR = '\u220b';

    public DefaultOWLHasValue(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    public DefaultOWLHasValue() {
    }

    public void accept(OWLModelVisitor visitor) {
        visitor.visitOWLHasValue(this);
    }

    public void checkFillerText(String text) throws Exception {
        DefaultOWLHasValue.checkFillerText(text, this.getOnProperty());
    }

    public static void checkFillerText(String text, RDFProperty onProperty) throws OWLClassParseException {
        if (onProperty != null && !(onProperty instanceof OWLDatatypeProperty)) {
            OWLModel owlModel = onProperty.getOWLModel();
            OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
            parser.checkHasValueFiller(owlModel, text);
        }
    }

    public boolean equalsStructurally(RDFObject object) {
        if (object instanceof OWLHasValue) {
            OWLHasValue compCls = (OWLHasValue)object;
            RDFObject compVal = compCls.getHasValue() instanceof RDFResource ? (RDFResource)compCls.getHasValue() : compCls.getOWLModel().asRDFSLiteral(compCls.getHasValue());
            RDFObject val = this.getHasValue() instanceof RDFResource ? (RDFResource)this.getHasValue() : compCls.getOWLModel().asRDFSLiteral(this.getHasValue());
            return this.getOnProperty().equalsStructurally(compCls.getOnProperty()) && val.equalsStructurally(compVal);
        }
        return false;
    }

    public RDFProperty getFillerProperty() {
        return this.getOWLModel().getRDFProperty("owl:hasValue");
    }

    public String getFillerText() {
        Object value = this.getHasValue();
        if (value == null) {
            return "";
        }
        if (value instanceof RDFResource) {
            return ((RDFResource)value).getBrowserText();
        }
        if (value instanceof String) {
            return "\"" + value + "\"";
        }
        return value.toString();
    }

    public Object getHasValue() {
        return this.getPropertyValue(this.getFillerProperty());
    }

    public String getIconName() {
        return "OWLHasValue";
    }

    public void getNestedNamedClasses(Set set) {
        if (this.getHasValue() instanceof RDFSClass) {
            ((RDFSClass)this.getHasValue()).getNestedNamedClasses(set);
        }
    }

    public char getOperator() {
        return '\u220b';
    }

    public void setFillerText(String text) throws Exception {
        OWLModel owlModel = this.getOWLModel();
        OWLClassParser parser = owlModel.getOWLClassDisplay().getParser();
        if (this.getOnProperty() instanceof OWLDatatypeProperty) {
            Object value = text;
            try {
                value = parser.parseHasValueFiller(owlModel, text);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setHasValue(value);
        } else {
            Object value = parser.parseHasValueFiller(owlModel, text);
            this.setHasValue(value);
        }
    }

    public void setHasValue(Object value) {
        if (value instanceof Double) {
            value = new Float((Double)value);
        }
        if (value instanceof Long) {
            value = new Integer(((Long)value).intValue());
        }
        this.setDirectOwnSlotValue(this.getFillerProperty(), value);
    }
}

