/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.components.triples;

import com.hp.hpl.jena.datatypes.xsd.impl.XMLLiteralType;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFList;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueAdapter;
import edu.stanford.smi.protegex.owl.model.event.PropertyValueListener;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFSLiteral;
import edu.stanford.smi.protegex.owl.model.impl.XMLSchemaDatatypes;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.actions.triple.DeleteTripleAction;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTable;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationsWidgetPlugin;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TriplesTableModel
extends AbstractTableModel {
    private ArrayList properties = new ArrayList();
    private RDFResource subject;
    private JTable table;
    private PropertyValueListener valueListener = new PropertyValueAdapter(){

        public void propertyValueChanged(RDFResource resource, RDFProperty property, Collection oldValues) {
            if (TriplesTableModel.this.isRelevantProperty(property)) {
                TriplesTableModel.this.updateValues();
            }
        }
    };
    private ArrayList values = new ArrayList();
    public static final int COL_PROPERTY = 0;
    public static final int COL_VALUE = 1;

    public TriplesTableModel() {
    }

    public TriplesTableModel(RDFResource subject) {
        this.subject = subject;
        if (subject != null) {
            subject.addPropertyValueListener(this.valueListener);
        }
        this.refill();
    }

    public int addRow(RDFProperty property) {
        Object value = this.createDefaultValue(property);
        if (value != null) {
            return this.addRow(property, value);
        }
        return -1;
    }

    public int addRow(RDFProperty property, Object value) {
        if (!this.subject.hasPropertyValue(property, value)) {
            this.subject.addPropertyValue(property, value);
        }
        return this.getPropertyValueRow(property, value);
    }

    private Object createDefaultValue(RDFProperty property) {
        Iterator it = TriplesComponent.plugins();
        while (it.hasNext()) {
            Object defaultValue;
            AnnotationsWidgetPlugin plugin = (AnnotationsWidgetPlugin)it.next();
            if (!plugin.canEdit(this.subject, property, null) || (defaultValue = plugin.createDefaultValue(this.subject, property)) == null) continue;
            return defaultValue;
        }
        RDFResource range = property.getRange();
        if (range instanceof RDFSDatatype) {
            return ((RDFSDatatype)range).getDefaultValue();
        }
        if (range instanceof OWLDataRange) {
            List values;
            OWLDataRange dataRange = (OWLDataRange)range;
            RDFList oneOf = dataRange.getOneOf();
            Object firstValue = null;
            if (oneOf != null && !(values = oneOf.getValues()).isEmpty()) {
                firstValue = values.iterator().next();
            }
            return firstValue;
        }
        if (property instanceof OWLObjectProperty) {
            return null;
        }
        return "";
    }

    private Object createNewValue(RDFProperty property, String text, String language) {
        Object newValue = null;
        newValue = language == null || language.trim().length() == 0 ? text : property.getOWLModel().createRDFSLiteralOrString(text, language);
        return newValue;
    }

    public void deleteRow(int rowIndex) {
        RDFProperty property = this.getPredicate(rowIndex);
        Object value = this.getValue(rowIndex);
        this.subject.removePropertyValue(property, value);
    }

    public void dispose() {
        if (this.subject != null) {
            this.subject.removePropertyValueListener(this.valueListener);
        }
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return RDFProperty.class;
        }
        if (column == 1) {
            return Object.class;
        }
        if (this.hasTypeColumn() && column == 2) {
            return RDFResource.class;
        }
        return String.class;
    }

    public int getColumnCount() {
        return this.hasTypeColumn() ? 4 : 3;
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return "Property";
        }
        if (column == 1) {
            return "Value";
        }
        if (this.isTypeColumn(column)) {
            return "Type";
        }
        return "Lang";
    }

    public Object getDisplayValue(int rowIndex) {
        Object value = this.values.get(rowIndex);
        if (value instanceof RDFSLiteral) {
            return ((RDFSLiteral)value).getString();
        }
        return value;
    }

    public String getLanguage(int row) {
        Object value = this.getValue(row);
        if (value instanceof RDFSLiteral) {
            return ((RDFSLiteral)value).getLanguage();
        }
        return null;
    }

    public OWLModel getOWLModel() {
        return this.subject.getOWLModel();
    }

    public RDFProperty getPredicate(int rowIndex) {
        return (RDFProperty)this.properties.get(rowIndex);
    }

    public int getPropertyValueRow(RDFProperty property, Object value) {
        int i = 0;
        while (i < this.properties.size()) {
            RDFProperty s = this.getPredicate(i);
            if (s.equals(property)) {
                if (value == null && this.getValue(i) == null) {
                    return i;
                }
                if (value != null && value.equals(this.getValue(i))) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    protected Collection getRelevantProperties() {
        OWLModel owlModel = this.subject.getOWLModel();
        HashSet<RDFProperty> props = new HashSet<RDFProperty>();
        for (RDFProperty curProp : owlModel.getRDFProperties()) {
            if (!curProp.isVisible()) continue;
            props.add(curProp);
        }
        props.add(owlModel.getRDFSIsDefinedByProperty());
        props.add(owlModel.getRDFSLabelProperty());
        props.add(owlModel.getRDFProperty("rdfs:seeAlso"));
        props.add(owlModel.getOWLSameAsProperty());
        props.add(owlModel.getOWLEquivalentPropertyProperty());
        props.add(owlModel.getOWLDifferentFromProperty());
        props.add(owlModel.getOWLVersionInfoProperty());
        return props;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public RDFResource getSubject() {
        return this.subject;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getPredicate(rowIndex);
        }
        if (columnIndex == 1) {
            return this.getDisplayValue(rowIndex);
        }
        if (this.isTypeColumn(columnIndex)) {
            Object value = this.getValue(rowIndex);
            if (value instanceof RDFResource) {
                return ((RDFResource)value).getRDFType();
            }
            if (value instanceof RDFSLiteral) {
                return ((RDFSLiteral)value).getDatatype();
            }
            RDFSLiteral literal = DefaultRDFSLiteral.create(this.getOWLModel(), value);
            return literal.getDatatype();
        }
        return this.getLanguage(rowIndex);
    }

    public Object getValue(int rowIndex) {
        return this.values.get(rowIndex);
    }

    protected boolean hasTypeColumn() {
        return true;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            RDFProperty property = this.getPredicate(rowIndex);
            if (columnIndex == 1) {
                Object value = this.getValue(rowIndex);
                Iterator it = TriplesComponent.plugins();
                while (it.hasNext()) {
                    AnnotationsWidgetPlugin plugin = (AnnotationsWidgetPlugin)it.next();
                    if (!plugin.canEdit(this.subject, property, value)) continue;
                    return false;
                }
                OWLModel owlModel = property.getOWLModel();
                return property instanceof OWLDatatypeProperty && !property.isReadOnly() && owlModel.getTripleStoreModel().isActiveTriple(this.subject, property, value) || this.getDefaultProperties().contains(property) && value == null;
            }
            if (this.isTypeColumn(columnIndex)) {
                return this.getValueAt(rowIndex, columnIndex) instanceof RDFSDatatype;
            }
            return property instanceof OWLDatatypeProperty && property.getOWLModel().getXSDstring().equals(property.getRange()) && !property.isReadOnly();
        }
        return false;
    }

    public boolean isDeleteEnabled(int row) {
        RDFProperty predicate = this.getPredicate(row);
        Object object = this.getValue(row);
        return DeleteTripleAction.isSuitable(this.subject, predicate, object);
    }

    public static boolean isInvalidXMLLiteral(RDFProperty property, Object value) {
        if (XMLSchemaDatatypes.isXMLLiteralSlot(property) && value instanceof String && !XMLLiteralType.theXMLLiteralType.isValid((String)value)) {
            ProtegeUI.getModalDialogFactory().showErrorMessageDialog(property.getOWLModel(), "This value is not a valid XML literal:\n" + value);
            return true;
        }
        return false;
    }

    protected boolean isRelevantProperty(RDFProperty property) {
        return true;
    }

    private boolean isTypeColumn(int column) {
        return this.hasTypeColumn() && column == 2;
    }

    private void refill() {
        if (this.subject != null) {
            Collection properties = this.getRelevantProperties();
            RDFProperty[] ss = properties.toArray(new RDFProperty[0]);
            Arrays.sort(ss, new FrameComparator());
            int i = 0;
            while (i < ss.length) {
                RDFProperty property = ss[i];
                Collection values = this.subject.getPropertyValues(property);
                for (Object value : values) {
                    this.properties.add(property);
                    this.values.add(value);
                }
                ++i;
            }
            for (RDFProperty curProp : this.getDefaultProperties()) {
                if (this.properties.contains(curProp)) continue;
                this.properties.add(0, curProp);
                this.values.add(0, null);
            }
        }
    }

    private void setDatatype(int row, RDFSDatatype datatype) {
        Object oldValue = this.getValue(row);
        String lexicalValue = oldValue.toString();
        RDFSLiteral newValue = datatype.getOWLModel().createRDFSLiteral(lexicalValue, datatype);
        RDFProperty predicate = this.getPredicate(row);
        this.subject.removePropertyValue(predicate, oldValue);
        this.subject.addPropertyValue(predicate, newValue);
    }

    private Object setLanguage(int row, String newLanguage) {
        RDFProperty property = this.getPredicate(row);
        String text = (String)this.getDisplayValue(row);
        Object newValue = this.createNewValue(property, text, newLanguage);
        if (!this.subject.getPropertyValues(property).contains(newValue)) {
            Object oldValue = this.getValue(row);
            this.subject.removePropertyValue(property, oldValue);
            this.subject.addPropertyValue(property, newValue);
        }
        return newValue;
    }

    public void setSubject(RDFResource instance) {
        RDFResource oldSubject = this.subject;
        if (oldSubject != null) {
            oldSubject.removePropertyValueListener(this.valueListener);
        }
        this.subject = instance;
        this.properties.clear();
        this.values.clear();
        if (instance != null) {
            instance.addPropertyValueListener(this.valueListener);
            this.refill();
        }
        this.fireTableDataChanged();
    }

    public Object setValue(Object aValue, int row) {
        RDFProperty property = this.getPredicate(row);
        Object oldValue = this.getValue(row);
        if (oldValue == null || !oldValue.equals(aValue)) {
            RDFResource range = property.getRange();
            try {
                Object newValue;
                String str = aValue.toString();
                OWLModel owlModel = property.getOWLModel();
                if (owlModel.getOWLOntologyProperties().contains(property)) {
                    String message = String.valueOf(str) + " is not a valid URI.";
                    try {
                        new URI(str);
                    }
                    catch (Exception ex) {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, message);
                        return oldValue;
                    }
                    if (!str.startsWith("http://") && !str.startsWith("file:")) {
                        ProtegeUI.getModalDialogFactory().showErrorMessageDialog(owlModel, message);
                        return oldValue;
                    }
                }
                String lang = this.getLanguage(row);
                if (aValue instanceof RDFSLiteral && ((RDFSLiteral)aValue).getLanguage() != null) {
                    newValue = aValue;
                } else if (lang != null) {
                    newValue = this.createNewValue(property, str, lang);
                } else if (oldValue instanceof RDFSLiteral) {
                    RDFSLiteral oldLiteral = (RDFSLiteral)oldValue;
                    newValue = this.getOWLModel().createRDFSLiteral(str, oldLiteral.getDatatype());
                } else {
                    newValue = oldValue instanceof Boolean ? Boolean.valueOf(str.equals("true")) : (oldValue instanceof Float ? Float.valueOf(str) : (oldValue instanceof Integer ? Integer.valueOf(str) : str));
                }
                if (!this.subject.getPropertyValues(property).contains(newValue)) {
                    this.subject.removePropertyValue(property, oldValue);
                    this.subject.addPropertyValue(property, newValue);
                }
                return newValue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return oldValue;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.setValueAndGetIt(aValue, rowIndex, columnIndex);
    }

    public Object setValueAndGetIt(Object value, int row, int col) {
        if (col == 0) {
            return null;
        }
        if (col == 1) {
            return this.setValue(value, row);
        }
        if (this.isTypeColumn(col)) {
            if (value instanceof RDFSDatatype) {
                RDFSDatatype datatype = (RDFSDatatype)value;
                this.setDatatype(row, datatype);
                return datatype;
            }
            return null;
        }
        return this.setLanguage(row, (String)value);
    }

    void updateValues() {
        int index = -1;
        if (this.table != null) {
            index = this.table.getSelectedRow();
        }
        this.properties.clear();
        this.values.clear();
        this.refill();
        this.fireTableDataChanged();
        if (this.table != null && index >= 0 && index < this.getRowCount()) {
            this.table.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public void setTable(TriplesTable table) {
        this.table = table;
    }

    public Collection getDefaultProperties() {
        return Collections.EMPTY_LIST;
    }
}

