/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.types;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.ui.properties.types.AbstractPropertyTypesWidget;
import java.util.Collection;

public class OWLObjectPropertyTypesWidget
extends AbstractPropertyTypesWidget {
    private void alignRangeAndDomain() {
        Collection range;
        Collection domain;
        OWLObjectProperty property = (OWLObjectProperty)this.getEditedResource();
        if (property.isSymmetric() && (domain = property.getUnionDomain()).containsAll(range = property.getUnionRangeClasses())) {
            range.containsAll(domain);
        }
    }

    public void initialize() {
        OWLModel owlModel = this.getOWLModel();
        this.initialize(new RDFSNamedClass[]{owlModel.getRDFSNamedClass("owl:FunctionalProperty"), owlModel.getRDFSNamedClass("owl:InverseFunctionalProperty"), owlModel.getRDFSNamedClass("owl:SymmetricProperty"), owlModel.getRDFSNamedClass("owl:TransitiveProperty")});
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        if (cls instanceof RDFSNamedClass && slot.getName().equals(":DIRECT-TYPE")) {
            RDFSNamedClass t = (RDFSNamedClass)cls.getKnowledgeBase().getCls("owl:ObjectProperty");
            return cls.equals(t) || cls.hasSuperclass((Cls)t);
        }
        return false;
    }

    protected void postProcessChange(RDFSNamedClass type) {
        super.postProcessChange(type);
        if (type.equals(this.getOWLModel().getRDFResource("owl:SymmetricProperty"))) {
            this.alignRangeAndDomain();
            this.updateInverseProperty();
        }
    }

    private void updateInverseProperty() {
        OWLObjectProperty property = (OWLObjectProperty)this.getEditedResource();
        if (property.isSymmetric()) {
            property.setInverseProperty(property);
        } else {
            property.setInverseProperty(null);
        }
    }
}

