/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.subsumption;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.subsumption.ChangedClassesTableModel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;

public class ChangedClassesPanel
extends ResultsPanel {
    private Action assertAction = new AbstractAction("Assert selected change(s)", OWLIcons.getAssertChangeIcon()){

        public void actionPerformed(ActionEvent e) {
            ChangedClassesPanel.this.assertSelectedChanges();
        }
    };
    private static Map panels = new HashMap();
    private Action showAction = new AbstractAction("Show selected class in hierarchies", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent e) {
            ChangedClassesPanel.this.showSelectedCls();
        }
    };
    private ChangedClassesTableModel tableModel;
    private JTable table;
    public static final String TAB_NAME = "Classification Results";

    public ChangedClassesPanel(OWLModel owlModel) {
        super(owlModel);
        this.tableModel = new ChangedClassesTableModel(owlModel);
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChangedClassesPanel.this.showSelectedCls();
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ChangedClassesPanel.this.updateActions();
            }
        });
        this.table.setDefaultRenderer(Frame.class, (TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(180);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(250);
        JScrollPane scrollPane = new JScrollPane(this.table);
        JViewport viewPort = scrollPane.getViewport();
        viewPort.setBackground(this.table.getBackground());
        this.addButton(this.assertAction);
        this.updateActions();
        this.setCenterComponent(scrollPane);
    }

    private void assertSelectedChanges() {
        int[] rows = this.table.getSelectedRows();
        this.tableModel.assertChanges(rows);
    }

    public boolean contains(Cls cls) {
        return this.tableModel.contains(cls);
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    public static void dispose(OWLModel owlModel) {
        ChangedClassesPanel panel = (ChangedClassesPanel)panels.get(owlModel);
        if (panel != null) {
            panels.remove(owlModel);
            panel.dispose();
        }
    }

    public static ChangedClassesPanel get(OWLModel owlModel) {
        ChangedClassesPanel panel = (ChangedClassesPanel)panels.get(owlModel);
        if (panel == null) {
            panel = new ChangedClassesPanel(owlModel);
            panels.put(owlModel, panel);
        }
        return panel;
    }

    public int getChangeCount() {
        return this.tableModel.getRowCount();
    }

    public String getChangeText(Cls cls) {
        return this.tableModel.getChangeText(cls);
    }

    public Icon getIcon() {
        return OWLIcons.getImageIcon("ChangedClasses");
    }

    public String getTabName() {
        return TAB_NAME;
    }

    ChangedClassesTableModel getTableModel() {
        return this.tableModel;
    }

    public void refresh() {
        this.tableModel.refill();
    }

    private void showSelectedCls() {
        Cls cls;
        int row = this.table.getSelectedRow();
        if (row >= 0 && (cls = this.tableModel.getCls(row)) instanceof RDFSClass) {
            this.showHostResource((RDFSClass)cls);
        }
    }

    private void updateActions() {
        int[] rows = this.table.getSelectedRows();
        this.showAction.setEnabled(rows.length == 1);
        if (rows.length > 0) {
            int i = 0;
            while (i < rows.length) {
                int row = rows[i];
                Cls cls = this.tableModel.getCls(row);
                if (!OWLUtil.isInconsistent(cls) && cls.isEditable()) {
                    this.assertAction.setEnabled(true);
                    return;
                }
                ++i;
            }
        }
        this.assertAction.setEnabled(false);
    }
}

