/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import com.hexidec.ekit.EkitCore;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.ComponentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HTMLEditorPanel
extends JPanel {
    private EkitCore ekitCore;
    private JComboBox languageComboBox;

    public HTMLEditorPanel(OWLModel owlModel, RDFSLiteral literal) {
        this(owlModel, literal.getString(), literal.getLanguage());
    }

    public HTMLEditorPanel(String text) {
        this(null, text, null);
    }

    public HTMLEditorPanel(OWLModel owlModel, String text, String language) {
        this.setLayout(new BorderLayout());
        this.ekitCore = new EkitCore(null, null, null, null, false, true, true, null, null, false, false);
        this.ekitCore.setDocumentText(text);
        JPanel ekitTopPanel = new JPanel();
        ekitTopPanel.setLayout(new GridLayout(2, 1));
        ekitTopPanel.add(this.ekitCore.getMenuBar());
        ekitTopPanel.add(this.ekitCore.getToolBar(true));
        if (owlModel != null) {
            this.languageComboBox = ComponentUtil.createLanguageComboBox(owlModel, language);
            Box languagePanel = Box.createHorizontalBox();
            languagePanel.add(new JLabel("Language: "));
            languagePanel.add(this.languageComboBox);
            this.add("South", languagePanel);
        }
        this.add("North", ekitTopPanel);
        this.add("Center", (Component)this.ekitCore);
    }

    public String getFullText() {
        return this.ekitCore.getDocumentText().trim();
    }

    public RDFSLiteral getRDFSLiteral(OWLModel owlModel) {
        String text = this.getText();
        if (text != null) {
            String lang = null;
            Object language = this.languageComboBox.getSelectedItem();
            if (language instanceof String && ((String)language).trim().length() > 0) {
                lang = ((String)language).trim();
            }
            return owlModel.createRDFSLiteral(text, lang);
        }
        return null;
    }

    public String getText() {
        return this.ekitCore.getDocumentBody().trim();
    }

    public static String show(Component parent, String text, String title) {
        return HTMLEditorPanel.show(parent, text, title, false);
    }

    public static String show(Component parent, String text, String title, boolean fullText) {
        HTMLEditorPanel panel = new HTMLEditorPanel(text);
        if (ProtegeUI.getModalDialogFactory().showDialog(parent, panel, title, 11) == 1) {
            return fullText ? panel.getFullText() : panel.getText();
        }
        return null;
    }

    public static RDFSLiteral show(Component parent, RDFSLiteral literal, String title, OWLModel owlModel) {
        HTMLEditorPanel panel = new HTMLEditorPanel(owlModel, literal);
        if (ProtegeUI.getModalDialogFactory().showDialog(parent, panel, title, 11) == 1) {
            return panel.getRDFSLiteral(owlModel);
        }
        return null;
    }
}

