/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Reference;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.ClosureUtils;
import edu.stanford.smi.protege.model.framestore.NarrowFrameStore;
import edu.stanford.smi.protege.model.framestore.Record;
import edu.stanford.smi.protege.model.framestore.ReferenceImpl;
import edu.stanford.smi.protege.model.query.Query;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SimpleStringMatcher;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InMemoryFrameDb
implements NarrowFrameStore {
    private static Logger log = Log.getLogger(InMemoryFrameDb.class);
    private static final int INITIAL_MAP_SIZE = 32771;
    private Map<FrameID, Frame> idToFrameMap = new HashMap<FrameID, Frame>(32771);
    private Map referenceToRecordMap = new HashMap(32771);
    private Map frameToRecordsMap = new HashMap(32771);
    private Map slotToRecordsMap = new HashMap(32771);
    private Map facetToRecordsMap = new HashMap(32771);
    private Map valueToRecordsMap = new LinkedHashMap(32771);
    private Record lookupRecord = new Record();
    private static int counter = 10000;
    private int projectId = FrameID.allocateMemoryProjectPart();
    private String frameDBName;
    private Slot cachedNameSlot;

    public Collection getRecords() {
        return new ArrayList(this.referenceToRecordMap.keySet());
    }

    public String getName() {
        return this.frameDBName;
    }

    public void setName(String string) {
        this.frameDBName = string;
    }

    public InMemoryFrameDb(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Constructing InMemoryFrameDb with name " + string + " No delegate...");
        }
        this.frameDBName = string;
    }

    public FrameID generateFrameID() {
        return FrameID.createLocal(this.projectId, counter++);
    }

    public void close() {
        this.referenceToRecordMap = null;
        this.frameToRecordsMap = null;
        this.slotToRecordsMap = null;
        this.facetToRecordsMap = null;
        this.valueToRecordsMap = null;
        this.lookupRecord = null;
    }

    private Record lookup(Frame frame, Slot slot, Facet facet, boolean bl) {
        this.lookupRecord.set(frame, slot, facet, bl);
        return (Record)this.referenceToRecordMap.get(this.lookupRecord);
    }

    private static void addRecord(Map map, Object object, Record record) {
        if (object != null) {
            HashSet<Record> hashSet = (HashSet<Record>)map.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<Record>();
                map.put(object, hashSet);
            }
            hashSet.add(record);
        }
    }

    public static void removeRecord(Map map, Object object, Record record) {
        Set set;
        if (object != null && (set = (Set)map.get(object)) != null) {
            set.remove(record);
        }
    }

    private void createRecord(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        Record record = new Record(frame, slot, facet, bl, collection);
        this.addRecord(record);
    }

    private void addRecord(Record record) {
        this.referenceToRecordMap.put(record, record);
        this.idToFrameMap.put(record.getFrame().getFrameID(), record.getFrame());
        InMemoryFrameDb.addRecord(this.frameToRecordsMap, record.getFrame(), record);
        InMemoryFrameDb.addRecord(this.slotToRecordsMap, record.getSlot(), record);
        InMemoryFrameDb.addRecord(this.facetToRecordsMap, record.getFacet(), record);
        for (Object e : record.getValues()) {
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, e, record);
        }
    }

    private void removeRecord(Record record) {
        Object object2;
        this.referenceToRecordMap.remove(record);
        InMemoryFrameDb.removeRecord(this.frameToRecordsMap, record.getFrame(), record);
        InMemoryFrameDb.removeRecord(this.slotToRecordsMap, record.getSlot(), record);
        InMemoryFrameDb.removeRecord(this.facetToRecordsMap, record.getFacet(), record);
        for (Object object2 : record.getValues()) {
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, object2, record);
        }
        object2 = InMemoryFrameDb.lookupRecords(this.frameToRecordsMap, record.getFrame());
        if (object2 == null || object2.isEmpty()) {
            this.idToFrameMap.remove(record.getFrame().getFrameID());
        }
    }

    public void removeValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            record.removeValue(object);
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, object, record);
            if (record.isEmpty()) {
                this.removeRecord(record);
            }
        }
    }

    public void moveValue(Frame frame, Slot slot, Facet facet, boolean bl, int n, int n2) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            record.moveValue(n, n2);
        }
    }

    private static Set lookupRecords(Map map, Object object) {
        return (Set)map.get(object);
    }

    public Set getReferences(Object object) {
        Set set = InMemoryFrameDb.lookupRecords(this.valueToRecordsMap, object);
        return InMemoryFrameDb.recordsToReferences(set);
    }

    public Set getMatchingReferences(String string, int n) {
        Set set = this.getMatchingRecords(string, n);
        return InMemoryFrameDb.recordsToReferences(set);
    }

    private Set getMatchingRecords(String string, int n) {
        if (n < 1) {
            n = Integer.MAX_VALUE;
        }
        SimpleStringMatcher simpleStringMatcher = new SimpleStringMatcher(string);
        HashSet hashSet = new HashSet();
        Iterator iterator = this.valueToRecordsMap.entrySet().iterator();
        while (iterator.hasNext() && hashSet.size() < n) {
            Map.Entry entry = iterator.next();
            Object k = entry.getKey();
            if (!(k instanceof String) || !simpleStringMatcher.isMatch((String)k)) continue;
            Set set = (Set)entry.getValue();
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private static Set recordsToReferences(Set set) {
        HashSet<Reference> hashSet;
        if (set == null) {
            hashSet = Collections.EMPTY_SET;
        } else {
            hashSet = new HashSet<Reference>(set.size());
            for (Record record : set) {
                hashSet.add(InMemoryFrameDb.recordToReference(record));
            }
        }
        return hashSet;
    }

    private static Reference recordToReference(Record record) {
        Frame frame = record.getFrame();
        Slot slot = record.getSlot();
        Facet facet = record.getFacet();
        boolean bl = record.isTemplate();
        return new ReferenceImpl(frame, slot, facet, bl);
    }

    public Set executeQuery(Query query) {
        return null;
    }

    public void setValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record == null) {
            this.createRecord(frame, slot, facet, bl, collection);
        } else {
            this.removeRecordValues(record);
            record.setValues(collection);
            this.addRecordValues(record);
        }
    }

    private void removeRecordValues(Record record) {
        for (Object e : record.getInternalValues()) {
            InMemoryFrameDb.removeRecord(this.valueToRecordsMap, e, record);
        }
    }

    private void addRecordValues(Record record) {
        for (Object e : record.getInternalValues()) {
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, e, record);
        }
    }

    public void addValues(Frame frame, Slot slot, Facet facet, boolean bl, Collection collection) {
        for (Object e : collection) {
            this.addValue(frame, slot, facet, bl, e);
        }
    }

    public void addValue(Frame frame, Slot slot, Facet facet, boolean bl, Object object) {
        Record record = this.lookup(frame, slot, facet, bl);
        if (record == null) {
            this.createRecord(frame, slot, facet, bl, CollectionUtilities.createList(object));
        } else {
            record.addValue(object);
            InMemoryFrameDb.addRecord(this.valueToRecordsMap, object, record);
        }
    }

    public List getValues(Frame frame, Slot slot, Facet facet, boolean bl) {
        List list = Collections.EMPTY_LIST;
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            list = record.getValues();
        }
        return list;
    }

    public int getValuesCount(Frame frame, Slot slot, Facet facet, boolean bl) {
        int n = 0;
        Record record = this.lookup(frame, slot, facet, bl);
        if (record != null) {
            n = record.getValueCount();
        }
        return n;
    }

    public void deleteFrame(Frame frame) {
        this.removeRecords(this.frameToRecordsMap, frame);
        this.removeRecords(this.slotToRecordsMap, frame);
        this.removeRecords(this.facetToRecordsMap, frame);
        InMemoryFrameDb.removeFrameValue(this.valueToRecordsMap, frame);
    }

    private void removeRecords(Map map, Frame frame) {
        Collection collection = InMemoryFrameDb.lookupRecords(map, frame);
        if (collection != null) {
            collection = new ArrayList(collection);
            for (Record record : collection) {
                this.removeRecord(record);
            }
            map.remove(frame);
        }
    }

    private static void removeFrameValue(Map map, Frame frame) {
        Set set = InMemoryFrameDb.lookupRecords(map, frame);
        if (set != null) {
            for (Record record : set) {
                record.removeValue(frame);
            }
            map.remove(frame);
        }
    }

    public static boolean equals(Object object, Object object2) {
        return SystemUtilities.equals(object, object2);
    }

    private static boolean matches(Record record, Slot slot, Facet facet, boolean bl) {
        boolean bl2 = InMemoryFrameDb.equals(slot, record.getSlot()) && InMemoryFrameDb.equals(facet, record.getFacet()) && bl == record.isTemplate();
        return bl2;
    }

    public Set getFrames(Slot slot, Facet facet, boolean bl, Object object) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        Set set = InMemoryFrameDb.lookupRecords(this.valueToRecordsMap, object);
        if (set != null) {
            for (Record record : set) {
                if (!InMemoryFrameDb.matches(record, slot, facet, bl)) continue;
                hashSet.add(record.getFrame());
            }
        }
        return hashSet;
    }

    public Set getFramesWithAnyValue(Slot slot, Facet facet, boolean bl) {
        HashSet<Frame> hashSet = new HashSet<Frame>();
        Set set = facet != null ? InMemoryFrameDb.lookupRecords(this.facetToRecordsMap, facet) : InMemoryFrameDb.lookupRecords(this.slotToRecordsMap, slot);
        if (set != null) {
            for (Record record : set) {
                if (!InMemoryFrameDb.matches(record, slot, facet, bl)) continue;
                hashSet.add(record.getFrame());
            }
        }
        return hashSet;
    }

    public Set getMatchingFrames(Slot slot, Facet facet, boolean bl, String string, int n) {
        if (n < 1) {
            n = Integer.MAX_VALUE;
        }
        HashSet<Frame> hashSet = new HashSet<Frame>();
        Iterator iterator = this.getMatchingRecords(string, -1).iterator();
        while (iterator.hasNext() && hashSet.size() < n) {
            Record record = (Record)iterator.next();
            if (!InMemoryFrameDb.matches(record, slot, facet, bl)) continue;
            hashSet.add(record.getFrame());
        }
        return hashSet;
    }

    public boolean beginTransaction(String string) {
        return false;
    }

    public boolean commitTransaction() {
        return true;
    }

    public boolean rollbackTransaction() {
        return false;
    }

    private static void replaceFrameKey(Map map, Frame frame) {
        Collection collection = (Collection)map.remove(frame);
        if (collection != null) {
            map.put(frame, collection);
            for (Record record : collection) {
                record.replaceFrameReference(frame);
            }
        }
    }

    private void replaceFrameValues(Frame frame) {
        Collection collection = (Collection)this.valueToRecordsMap.remove(frame);
        if (collection != null) {
            this.valueToRecordsMap.put(frame, collection);
            for (Record record : collection) {
                record.replaceFrameValue(frame);
            }
        }
    }

    public void replaceFrame(Frame frame) {
        InMemoryFrameDb.replaceFrameKey(this.frameToRecordsMap, frame);
        InMemoryFrameDb.replaceFrameKey(this.slotToRecordsMap, frame);
        InMemoryFrameDb.replaceFrameKey(this.facetToRecordsMap, frame);
        InMemoryFrameDb.replaceFrameKey(this.valueToRecordsMap, frame);
        this.replaceFrameValues(frame);
    }

    public int getClsCount() {
        return this.countFrames(Cls.class);
    }

    public int getSlotCount() {
        return this.countFrames(Slot.class);
    }

    public int getFacetCount() {
        return this.countFrames(Facet.class);
    }

    public int getFrameCount() {
        Collection collection;
        int n = 0;
        Slot slot = this.getNameSlot();
        if (slot != null && (collection = (Collection)this.slotToRecordsMap.get(slot)) != null) {
            n = collection.size();
        }
        return n;
    }

    public Set getFrames() {
        return new HashSet(this.frameToRecordsMap.keySet());
    }

    public int getSimpleInstanceCount() {
        return this.countFrames(SimpleInstance.class);
    }

    private Slot getNameSlot() {
        Iterator iterator;
        if (this.cachedNameSlot == null && (iterator = this.referenceToRecordMap.keySet().iterator()).hasNext()) {
            Record record = (Record)iterator.next();
            Frame frame = record.getFrame();
            KnowledgeBase knowledgeBase = frame.getKnowledgeBase();
            this.cachedNameSlot = knowledgeBase.getSlot(":NAME");
        }
        return this.cachedNameSlot;
    }

    private int countFrames(Class clazz) {
        int n = 0;
        Slot slot = this.getNameSlot();
        if (slot != null) {
            Collection collection = (Collection)this.slotToRecordsMap.get(slot);
            for (Record record : collection) {
                if (!clazz.isInstance(record.getFrame())) continue;
                ++n;
            }
        }
        return n;
    }

    public Frame getFrame(FrameID frameID) {
        return this.idToFrameMap.get(frameID);
    }

    public String toString() {
        return StringUtilities.getClassName(this) + "(" + this.frameDBName + ")";
    }

    public Set getClosure(Frame frame, Slot slot, Facet facet, boolean bl) {
        return ClosureUtils.calculateClosure(this, frame, slot, facet, bl);
    }

    public NarrowFrameStore getDelegate() {
        return null;
    }
}

