/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore.undo;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.framestore.FrameStore;
import edu.stanford.smi.protege.model.framestore.FrameStore_Test;
import edu.stanford.smi.protege.model.framestore.InMemoryFrameStore;
import edu.stanford.smi.protege.model.framestore.undo.UndoFrameStore;

public class UndoFrameStore_Test
extends FrameStore_Test {
    private UndoFrameStore _frameStore;

    public FrameStore createFrameStore(DefaultKnowledgeBase defaultKnowledgeBase) {
        this._frameStore = new UndoFrameStore();
        this._frameStore.setDelegate(new InMemoryFrameStore(defaultKnowledgeBase));
        return this._frameStore;
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this._frameStore = null;
    }

    public void testUndoCreateCls() {
        Cls cls = this.createCls();
        String string = cls.getName();
        UndoFrameStore_Test.assertNotNull((String)"name", (Object)string);
        Frame frame = this.getFrame(string);
        UndoFrameStore_Test.assertEquals((String)"created", (Object)cls, (Object)frame);
        UndoFrameStore_Test.assertTrue((String)"can undo", (boolean)this._frameStore.canUndo());
        this._frameStore.undo();
        frame = this.getFrame(string);
        UndoFrameStore_Test.assertNull((String)"undone", (Object)frame);
        this._frameStore.redo();
        frame = this.getFrame(string);
        UndoFrameStore_Test.assertEquals((String)"recreated", (String)frame.getName(), (String)string);
    }

    public void testUndoCreateSimpleInstance() {
        Cls cls = this.createCls();
        Instance instance = this.createSimpleInstance(cls);
        String string = instance.getName();
        UndoFrameStore_Test.assertNotNull((String)"name", (Object)string);
        Frame frame = this.getFrame(string);
        UndoFrameStore_Test.assertEquals((String)"created", (Object)instance, (Object)frame);
        UndoFrameStore_Test.assertTrue((String)"can undo", (boolean)this._frameStore.canUndo());
        this._frameStore.undo();
        frame = this.getFrame(string);
        UndoFrameStore_Test.assertNull((String)"undone", (Object)frame);
        this._frameStore.redo();
        instance = (Instance)this.getFrame(string);
        UndoFrameStore_Test.assertEquals((String)"recreated", (String)instance.getName(), (String)string);
    }

    public void testUndoCreateSlot() {
        Slot slot = this.createSlot();
        String string = slot.getName();
        UndoFrameStore_Test.assertNotNull((String)"name", (Object)string);
        Frame frame = this.getFrame(string);
        UndoFrameStore_Test.assertEquals((String)"created", (Object)slot, (Object)frame);
        UndoFrameStore_Test.assertTrue((String)"can undo", (boolean)this._frameStore.canUndo());
        this._frameStore.undo();
        frame = this.getFrame(string);
        UndoFrameStore_Test.assertNull((String)"undone", (Object)frame);
        this._frameStore.redo();
        frame = this.getFrame(string);
        UndoFrameStore_Test.assertEquals((String)"recreated", (String)frame.getName(), (String)string);
    }

    public void testUndoCreateFacet() {
    }

    public void testUndoDeleteCls() {
        Cls cls = this.createCls();
        Cls cls2 = this.createCls();
        Cls cls3 = this.createCls(cls);
        Cls cls4 = this.createCls(cls2);
        Cls cls5 = this.createCls(cls3);
        this._frameStore.addDirectSuperclass(cls5, cls4);
        Cls cls6 = this.createCls(cls5);
        int n = this._frameStore.getFrames().size();
        this._frameStore.deleteCls(cls6);
        int n2 = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"first count", (int)(n - 1), (int)n2);
        this._frameStore.undo();
        n2 = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"second count", (int)n, (int)n2);
        this._frameStore.redo();
        n2 = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"third count", (int)(n - 1), (int)n2);
        this._frameStore.undo();
        n2 = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"forth count", (int)n, (int)n2);
        String string = this._frameStore.getFrameName(cls);
        this._frameStore.deleteCls(cls3);
        this._frameStore.deleteCls(cls);
        n2 = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"fifth count", (int)(n - 2), (int)n2);
        this._frameStore.undo();
        this._frameStore.undo();
        n2 = this._frameStore.getFrames().size();
        UndoFrameStore_Test.assertEquals((String)"sixth count", (int)n, (int)n2);
        Frame frame = this._frameStore.getFrame(string);
        UndoFrameStore_Test.assertNotNull((String)"clsA", (Object)frame);
    }

    public void testUndoSimpleTransaction() {
        Cls cls = this.createCls();
        Slot slot = this.createSlot();
        Slot slot2 = this.createSlot();
        cls.addDirectTemplateSlot(slot);
        cls.addDirectTemplateSlot(slot2);
        Instance instance = cls.createDirectInstance(null);
        this._frameStore.beginTransaction("simple nonsense");
        this._frameStore.setDirectOwnSlotValues(instance, slot, UndoFrameStore_Test.makeList("foo1"));
        this._frameStore.setDirectOwnSlotValues(instance, slot2, UndoFrameStore_Test.makeList("foo2"));
        this._frameStore.commitTransaction();
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo1"), this._frameStore.getDirectOwnSlotValues(instance, slot));
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo2"), this._frameStore.getDirectOwnSlotValues(instance, slot2));
        this._frameStore.undo();
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList(), this._frameStore.getDirectOwnSlotValues(instance, slot));
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList(), this._frameStore.getDirectOwnSlotValues(instance, slot2));
        this._frameStore.redo();
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo1"), this._frameStore.getDirectOwnSlotValues(instance, slot));
        UndoFrameStore_Test.assertEqualsList(UndoFrameStore_Test.makeList("foo2"), this._frameStore.getDirectOwnSlotValues(instance, slot2));
    }

    public void testUndoDeleteSlot() {
    }

    public void testUndoDeleteFacet() {
    }

    public void testUndoDeleteSimpleInstance() {
    }

    public void testUndoSetDirectOwnSlotValues() {
    }

    public void testUndoSetFrameName() {
    }

    public void testUndoAddDirectTemplateSlot() {
    }

    public void testUndoRemoveDirectTemplateSlot() {
    }

    public void testUndoMoveDirectTemplateSlot() {
    }

    public void testUndoSetDirectTemplateSlotValues() {
    }

    public void testUndoRemoveDirectTemplateFacetOverrides() {
    }

    public void testUndoSetDirectTemplateFacetValues() {
    }

    public void testUndoAddDirectSuperclass() {
    }

    public void testUndoRemoveDirectSuperclass() {
    }

    public void testUndoMoveDirectSubclass() {
    }

    public void testUndoAddDirectSuperslot() {
    }

    public void testUndoRemoveDirectSuperslot() {
    }

    public void testUndoAddDirectType() {
    }

    public void testUndoMoveDirectType() {
    }

    public void testUndoCommitTransaction() {
    }

    public void testUndoRollbackTransaction() {
    }
}

