/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.DocumentChangedListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;

public class IntegerField
extends JComponent {
    private ActionListener itsActionListener;
    private JTextField _textField;
    private JLabel _label;

    public IntegerField(String string) {
        this.setLayout(new BorderLayout());
        this._label = ComponentFactory.createLabel(string);
        this._label.setForeground(UIManager.getColor("Checkbox.foreground"));
        this.createTextField();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this._label, "West");
        jPanel.add((Component)this._textField, "Center");
        this.add((Component)jPanel, "North");
    }

    public void addActionListener(ActionListener actionListener) {
        this.itsActionListener = actionListener;
    }

    public void clearValue() {
        this._textField.setText("");
    }

    private JComponent createTextField() {
        this._textField = ComponentFactory.createTextField();
        this._textField.setHorizontalAlignment(4);
        this._textField.getDocument().addDocumentListener(new DocumentChangedListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                IntegerField.this.notifyChanged();
            }
        });
        this._textField.setColumns(3);
        return this._textField;
    }

    public Integer getValue() {
        Integer n;
        try {
            String string = this._textField.getText();
            n = new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = null;
        }
        return n;
    }

    private void notifyChanged() {
        if (this.itsActionListener != null) {
            this.itsActionListener.actionPerformed(new ActionEvent(this, 1001, null));
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.itsActionListener = null;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this._textField.setEnabled(bl);
        this._label.setEnabled(bl);
    }

    public void setValue(int n) {
        this._textField.setText(String.valueOf(n));
        this._textField.repaint();
    }
}

