/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.util.Assert;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.InstanceUtilities;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PropertyList
implements Cloneable {
    public static final String CLASS_PROPERTY_LIST = "Property_List";
    private static final String CLASS_WIDGET_DESCRIPTOR = "Widget";
    private static final String CLASS_STRING = "String";
    private static final String CLASS_INTEGER = "Integer";
    private static final String CLASS_BOOLEAN = "Boolean";
    private static final String CLASS_RECTANGLE = "Rectangle";
    private static final String SLOT_NAME = "name";
    private static final String SLOT_BOOLEAN_VALUE = "boolean_value";
    private static final String SLOT_INTEGER_VALUE = "integer_value";
    private static final String SLOT_STRING_VALUE = "string_value";
    private static final String SLOT_PROPERTIES = "properties";
    private Map nameToSlotMap = new HashMap();
    private Instance _instance;

    public PropertyList(Instance instance) {
        Assert.assertNotNull("instance", instance);
        Assert.assertEquals("class name", instance.getDirectType().getName(), CLASS_PROPERTY_LIST);
        this._instance = instance;
    }

    private void addProperty(Instance instance) {
        Assert.assertNotNull("property", instance);
        this.addValue(SLOT_PROPERTIES, instance);
    }

    public void clear() {
        KnowledgeBase knowledgeBase = this._instance.getKnowledgeBase();
        Collection collection = this.getValues(SLOT_PROPERTIES);
        for (Instance instance : knowledgeBase.getReachableSimpleInstances(collection)) {
            knowledgeBase.deleteInstance(instance);
        }
        this.setValue(SLOT_PROPERTIES, null);
    }

    public Object clone() {
        Instance instance = (Instance)this._instance.deepCopy(null, null);
        return new PropertyList(instance);
    }

    public static PropertyList create(KnowledgeBase knowledgeBase) {
        Cls cls = knowledgeBase.getCls(CLASS_PROPERTY_LIST);
        Instance instance = knowledgeBase.createInstance(null, cls);
        return new PropertyList(instance);
    }

    private Instance createInstance(String string) {
        KnowledgeBase knowledgeBase = this._instance.getKnowledgeBase();
        Cls cls = knowledgeBase.getCls(string);
        return knowledgeBase.createInstance(null, cls);
    }

    private Instance createProperty(String string, String string2) {
        Instance instance = this.createInstance(string2);
        this.setValue(instance, SLOT_NAME, string);
        this.addProperty(instance);
        return instance;
    }

    public WidgetDescriptor createWidgetDescriptor(String string) {
        Instance instance = this.getOrCreateProperty(string, CLASS_WIDGET_DESCRIPTOR);
        WidgetDescriptor widgetDescriptor = WidgetDescriptor.create(instance);
        return widgetDescriptor;
    }

    public Boolean getBoolean(String string) {
        Instance instance = this.getProperty(string);
        return instance == null ? (Boolean)null : (Boolean)this.getValue(instance, SLOT_BOOLEAN_VALUE);
    }

    public Dimension getDimension(String string) {
        Instance instance = this.getProperty(string);
        return instance == null ? (Dimension)null : InstanceUtilities.getDimension(instance);
    }

    public Integer getInteger(String string) {
        Instance instance = this.getProperty(string);
        return instance == null ? (Integer)null : (Integer)this.getValue(instance, SLOT_INTEGER_VALUE);
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._instance.getKnowledgeBase();
    }

    public Collection getNames() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Instance instance : this.getValues(SLOT_PROPERTIES)) {
            arrayList.add(this.getValue(instance, SLOT_NAME));
        }
        return arrayList;
    }

    public Collection getLiveWidgetDescriptors() {
        ArrayList<WidgetDescriptor> arrayList = new ArrayList<WidgetDescriptor>();
        for (Instance instance : this.getValues(SLOT_PROPERTIES)) {
            if (!WidgetDescriptor.isActiveWidget(instance)) continue;
            WidgetDescriptor widgetDescriptor = WidgetDescriptor.create(instance);
            arrayList.add(widgetDescriptor);
        }
        return arrayList;
    }

    private Instance getOrCreateProperty(String string, String string2) {
        Instance instance = this.getProperty(string);
        if (instance == null) {
            instance = this.createProperty(string, string2);
        } else if (!instance.getDirectType().getName().equals(string2)) {
            instance = this.replaceProperty(string, instance, string2);
        }
        return instance;
    }

    private Instance getProperty(String string) {
        Instance instance = null;
        if (string != null) {
            for (Instance instance2 : this.getValues(SLOT_PROPERTIES)) {
                String string2 = (String)this.getValue(instance2, SLOT_NAME);
                if (!string.equals(string2)) continue;
                instance = instance2;
                break;
            }
        }
        return instance;
    }

    public PropertyList getPropertyList(String string) {
        Instance instance = this.getOrCreateProperty(string, CLASS_PROPERTY_LIST);
        return new PropertyList(instance);
    }

    public Rectangle getRectangle(String string) {
        Instance instance = this.getProperty(string);
        return instance == null ? (Rectangle)null : InstanceUtilities.getRectangle(instance);
    }

    public String getString(String string) {
        Instance instance = this.getProperty(string);
        return instance == null ? (String)null : (String)this.getValue(instance, SLOT_STRING_VALUE);
    }

    private Collection getValues(String string) {
        return this.getValues(this._instance, string);
    }

    public WidgetDescriptor getWidgetDescriptor(String string) {
        Instance instance = this.getProperty(string);
        WidgetDescriptor widgetDescriptor = instance == null ? null : WidgetDescriptor.create(instance);
        return widgetDescriptor;
    }

    public Instance getWrappedInstance() {
        return this._instance;
    }

    public void remove(String string) {
        Assert.assertNotNull(SLOT_NAME, string);
        for (Instance instance : this.getValues(SLOT_PROPERTIES)) {
            String string2 = (String)this.getValue(instance, SLOT_NAME);
            if (!string.equals(string2)) continue;
            this.removeValue(SLOT_PROPERTIES, instance);
            break;
        }
    }

    private void removeProperty(Instance instance) {
        Assert.assertNotNull("property", instance);
        this.removeValue(SLOT_PROPERTIES, instance);
    }

    private void replaceProperty(Instance instance) {
        String string = (String)this.getValue(instance, SLOT_NAME);
        if (this.getProperty(string) != null) {
            this.remove(string);
        }
        this.addProperty(instance);
    }

    private Instance replaceProperty(String string, Instance instance, String string2) {
        this.removeProperty(instance);
        Instance instance2 = this.createProperty(string, string2);
        return instance2;
    }

    public void setBoolean(String string, Boolean bl) {
        this.setProperty(string, CLASS_BOOLEAN, SLOT_BOOLEAN_VALUE, bl);
    }

    public void setBoolean(String string, boolean bl) {
        this.setProperty(string, CLASS_BOOLEAN, SLOT_BOOLEAN_VALUE, bl);
    }

    public void setInteger(String string, int n) {
        this.setProperty(string, CLASS_INTEGER, SLOT_INTEGER_VALUE, new Integer(n));
    }

    public void setInteger(String string, Integer n) {
        this.setProperty(string, CLASS_INTEGER, SLOT_INTEGER_VALUE, n);
    }

    private void setProperty(String string, String string2, String string3, Object object) {
        Instance instance = this.getOrCreateProperty(string, string2);
        this.setValue(instance, string3, object);
    }

    public void setRectangle(String string, Rectangle rectangle) {
        Instance instance = this.getOrCreateProperty(string, CLASS_RECTANGLE);
        InstanceUtilities.setRectangle(instance, rectangle);
    }

    public void setString(String string, String string2) {
        this.setProperty(string, CLASS_STRING, SLOT_STRING_VALUE, string2);
    }

    private void setValue(String string, Object object) {
        this.setValue(this._instance, string, object);
    }

    public void setWidgetDescriptor(WidgetDescriptor widgetDescriptor) {
        this.replaceProperty(widgetDescriptor.getInstance());
    }

    public String toString() {
        String string = CollectionUtilities.toString(this.getNames());
        return "PropertyList(" + string + ")";
    }

    private Slot getSlot(String string) {
        Slot slot = (Slot)this.nameToSlotMap.get(string);
        if (slot == null) {
            slot = this._instance.getKnowledgeBase().getSlot(string);
            this.nameToSlotMap.put(string, slot);
        }
        return slot;
    }

    private void addValue(String string, Object object) {
        this._instance.addOwnSlotValue(this.getSlot(string), object);
    }

    private void removeValue(String string, Object object) {
        this._instance.removeOwnSlotValue(this.getSlot(string), object);
    }

    private Collection getValues(Instance instance, String string) {
        return instance.getDirectOwnSlotValues(this.getSlot(string));
    }

    private Object getValue(Instance instance, String string) {
        return instance.getDirectOwnSlotValue(this.getSlot(string));
    }

    private void setValue(Instance instance, String string, Object object) {
        instance.setDirectOwnSlotValue(this.getSlot(string), object);
    }
}

