/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.model.framestore;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultCls;
import edu.stanford.smi.protege.model.DefaultFacet;
import edu.stanford.smi.protege.model.DefaultSimpleInstance;
import edu.stanford.smi.protege.model.DefaultSlot;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.FrameFactory;
import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.SimpleInstance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.CollectionUtilities;
import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.SystemUtilities;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultFrameFactory
implements FrameFactory {
    public static final int DEFAULT_CLS_JAVA_CLASS_ID = 6;
    public static final int DEFAULT_SLOT_JAVA_CLASS_ID = 7;
    public static final int DEFAULT_FACET_JAVA_CLASS_ID = 8;
    public static final int DEFAULT_SIMPLE_INSTANCE_JAVA_CLASS_ID = 5;
    private static final Class[] CONSTRUCTOR_PARAMETERS = new Class[]{KnowledgeBase.class, FrameID.class};
    private KnowledgeBase _kb;
    private Collection _packages = new ArrayList();
    private Map _typesToImplementationClassMap = new HashMap();

    public DefaultFrameFactory(KnowledgeBase knowledgeBase) {
        this._kb = knowledgeBase;
    }

    public KnowledgeBase getKnowledgeBase() {
        return this._kb;
    }

    public void addJavaPackage(String string) {
        this._packages.add(string);
    }

    public void removeJavaPackage(String string) {
        this._packages.remove(string);
    }

    public Cls createCls(FrameID frameID, Collection collection) {
        Class clazz = this.getImplementationClass(collection, DefaultCls.class);
        return this.createCls(frameID, clazz);
    }

    protected Cls createCls(FrameID frameID, Class clazz) {
        Cls cls = clazz.equals(DefaultCls.class) ? new DefaultCls(this._kb, frameID) : (Cls)this.createInstance(frameID, clazz);
        this.configureCls(cls);
        return cls;
    }

    public Slot createSlot(FrameID frameID, Collection collection) {
        Class clazz = this.getImplementationClass(collection, DefaultSlot.class);
        return this.createSlot(frameID, clazz);
    }

    protected Slot createSlot(FrameID frameID, Class clazz) {
        Slot slot = clazz.equals(DefaultSlot.class) ? new DefaultSlot(this._kb, frameID) : (Slot)this.createInstance(frameID, clazz);
        this.configureSlot(slot);
        return slot;
    }

    public Facet createFacet(FrameID frameID, Collection collection) {
        Class clazz = this.getImplementationClass(collection, DefaultFacet.class);
        return this.createFacet(frameID, clazz);
    }

    protected Facet createFacet(FrameID frameID, Class clazz) {
        Facet facet = clazz.equals(DefaultFacet.class) ? new DefaultFacet(this._kb, frameID) : (Facet)this.createInstance(frameID, clazz);
        this.configureFacet(facet);
        return facet;
    }

    public SimpleInstance createSimpleInstance(FrameID frameID, Collection collection) {
        Class clazz = this.getImplementationClass(collection, DefaultSimpleInstance.class);
        return this.createSimpleInstance(frameID, clazz);
    }

    protected SimpleInstance createSimpleInstance(FrameID frameID, Class clazz) {
        SimpleInstance simpleInstance = clazz.equals(DefaultSimpleInstance.class) ? new DefaultSimpleInstance(this._kb, frameID) : (SimpleInstance)this.createInstance(frameID, clazz);
        this.configureSimpleInstance(simpleInstance);
        return simpleInstance;
    }

    protected void configureFacet(Facet facet) {
        Facet facet2;
        if (facet.isSystem() && (facet2 = (Facet)this.getCachedSystemFrame(facet.getFrameID())) != null) {
            facet.setConstraint(facet2.getConstraint());
        }
    }

    protected void configureSimpleInstance(SimpleInstance simpleInstance) {
    }

    protected void configureCls(Cls cls) {
    }

    protected void configureSlot(Slot slot) {
    }

    private Frame getCachedSystemFrame(FrameID frameID) {
        return this._kb.getSystemFrames().getFrame(frameID);
    }

    protected Class getImplementationClass(Collection collection, Class clazz) {
        Class clazz2;
        if (this._packages.isEmpty() || collection.size() != 1) {
            clazz2 = clazz;
        } else {
            Cls cls = (Cls)CollectionUtilities.getFirstItem(collection);
            clazz2 = (Class)this._typesToImplementationClassMap.get(cls);
            if (clazz2 == null) {
                clazz2 = this.getJavaImplementationClass(cls, clazz);
            }
            this._typesToImplementationClassMap.put(cls, clazz2);
        }
        return clazz2;
    }

    public boolean isCorrectJavaImplementationClass(FrameID frameID, Collection collection, Class clazz) {
        return this.getImplementationClass(collection, clazz).equals(clazz);
    }

    private Instance createInstance(FrameID frameID, Class clazz) {
        Instance instance = null;
        try {
            Constructor constructor = clazz.getConstructor(CONSTRUCTOR_PARAMETERS);
            instance = (Instance)constructor.newInstance(this._kb, frameID);
        }
        catch (Exception exception) {
            Log.getLogger().severe(Log.toString(exception));
        }
        return instance;
    }

    private Class getJavaImplementationClass(Cls cls, Class clazz) {
        Class clazz2 = null;
        Iterator iterator = this._packages.iterator();
        while (iterator.hasNext() && clazz2 == null) {
            String string = (String)iterator.next();
            clazz2 = this.getJavaImplementationClass(string, cls);
        }
        if (clazz2 == null) {
            clazz2 = clazz;
        } else if (!DefaultFrameFactory.isValidImplementationClass(clazz2, clazz)) {
            Log.getLogger().warning("Java implementation class of wrong type: " + clazz2);
            clazz2 = clazz;
        }
        return clazz2;
    }

    private static boolean isValidImplementationClass(Class clazz, Class clazz2) {
        return clazz2.isAssignableFrom(clazz);
    }

    private Class getJavaImplementationClass(String string, Cls cls) {
        String string2 = this.getJavaClassName(cls);
        String string3 = string + "." + string2;
        return SystemUtilities.forName(string3, true);
    }

    protected String getJavaClassName(Cls cls) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = cls.getName();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!this.isValidCharacter(c, stringBuffer.length())) continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected boolean isValidCharacter(char c, int n) {
        return n == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
    }

    public int getJavaClassId(Frame frame) {
        int n = frame instanceof Cls ? 6 : (frame instanceof Slot ? 7 : (frame instanceof Facet ? 8 : 5));
        return n;
    }

    public Frame createFrameFromClassId(int n, FrameID frameID) {
        Instance instance;
        switch (n) {
            case 6: {
                instance = this.createCls(frameID, DefaultCls.class);
                break;
            }
            case 7: {
                instance = this.createSlot(frameID, DefaultSlot.class);
                break;
            }
            case 8: {
                instance = this.createFacet(frameID, DefaultFacet.class);
                break;
            }
            case 5: {
                instance = this.createSimpleInstance(frameID, DefaultSimpleInstance.class);
                break;
            }
            default: {
                throw new RuntimeException("Invalid java class id: " + n);
            }
        }
        return instance;
    }

    private static Collection createRange(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(n));
        return arrayList;
    }

    public Collection getClsJavaClassIds() {
        return DefaultFrameFactory.createRange(6);
    }

    public Collection getSlotJavaClassIds() {
        return DefaultFrameFactory.createRange(7);
    }

    public Collection getFacetJavaClassIds() {
        return DefaultFrameFactory.createRange(8);
    }

    public Collection getSimpleInstanceJavaClassIds() {
        return DefaultFrameFactory.createRange(5);
    }
}

