/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.storage.database;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.DefaultKnowledgeBase;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Slot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class KnowledgeBaseUtils {
    public static void update(KnowledgeBase knowledgeBase) {
        boolean bl = knowledgeBase.setCleanDispatchEnabled(false);
        DefaultKnowledgeBase defaultKnowledgeBase = new DefaultKnowledgeBase();
        for (Frame frame : defaultKnowledgeBase.getFrames()) {
            KnowledgeBaseUtils.updateFrame(frame, knowledgeBase);
        }
        knowledgeBase.setCleanDispatchEnabled(bl);
    }

    private static void updateFrame(Frame frame, KnowledgeBase knowledgeBase) {
        KnowledgeBaseUtils.updateOwnSlots(frame, knowledgeBase);
        if (frame instanceof Cls) {
            KnowledgeBaseUtils.updateTemplateSlots((Cls)frame, knowledgeBase);
        }
    }

    private static void updateOwnSlots(Frame frame, KnowledgeBase knowledgeBase) {
        for (Slot slot : frame.getOwnSlots()) {
            KnowledgeBaseUtils.updateOwnSlotValues(frame, slot, knowledgeBase);
        }
    }

    private static void updateTemplateSlots(Cls cls, KnowledgeBase knowledgeBase) {
        for (Slot slot : cls.getTemplateSlots()) {
            KnowledgeBaseUtils.updateTemplateSlotValues(cls, slot, knowledgeBase);
            KnowledgeBaseUtils.updateTemplateFacets(cls, slot, knowledgeBase);
        }
    }

    private static List getNewValues(List list, List list2, KnowledgeBase knowledgeBase) {
        ArrayList<Object> arrayList = null;
        if (!((Object)list).equals(list2)) {
            Object object2;
            arrayList = new ArrayList<Object>();
            for (Object object2 : list) {
                if (object2 instanceof Frame) {
                    Frame frame = (Frame)object2;
                    arrayList.add(KnowledgeBaseUtils.getFrame(frame, knowledgeBase));
                    continue;
                }
                arrayList.add(object2);
            }
            object2 = new ArrayList(list2);
            object2.removeAll(arrayList);
            arrayList.addAll(KnowledgeBaseUtils.getCurrentUserFrames((Collection)object2));
            if (KnowledgeBaseUtils.equalsSet(arrayList, list2)) {
                arrayList = null;
            }
        }
        return arrayList;
    }

    private static boolean equalsSet(Collection collection, Collection collection2) {
        return new HashSet(collection).equals(new HashSet(collection2));
    }

    private static Collection getCurrentUserFrames(Collection collection) {
        ArrayList<Frame> arrayList = new ArrayList<Frame>();
        for (Object e : collection) {
            Frame frame;
            if (!(e instanceof Frame) || (frame = (Frame)e).isSystem()) continue;
            arrayList.add(frame);
        }
        return arrayList;
    }

    private static Frame getFrame(Frame frame, KnowledgeBase knowledgeBase) {
        Frame frame2 = knowledgeBase.getFrame(frame.getName());
        if (frame2 == null) {
            Cls cls = ((Instance)frame).getDirectType();
            if (cls.equals(frame)) {
                Cls cls2 = knowledgeBase.createCls(frame.getFrameID(), frame.getName(), Collections.EMPTY_LIST, Collections.EMPTY_LIST, false);
                cls2.setDirectType(cls2);
                frame2 = cls2;
            } else {
                Cls cls3 = (Cls)KnowledgeBaseUtils.getFrame(cls, knowledgeBase);
                frame2 = knowledgeBase.createInstance(frame.getFrameID(), frame.getName(), cls3, false);
            }
            KnowledgeBaseUtils.trace("create frame: " + frame);
        }
        return frame2;
    }

    private static void updateTemplateSlotValues(Cls cls, Slot slot, KnowledgeBase knowledgeBase) {
        Slot slot2;
        Cls cls2;
        List list;
        List list2 = cls.getDirectTemplateSlotValues(slot);
        List list3 = KnowledgeBaseUtils.getNewValues(list2, list = (cls2 = (Cls)KnowledgeBaseUtils.getFrame(cls, knowledgeBase)).getDirectTemplateSlotValues(slot2 = (Slot)KnowledgeBaseUtils.getFrame(slot, knowledgeBase)), knowledgeBase);
        if (list3 != null) {
            cls2.setTemplateSlotValues(slot2, list3);
            KnowledgeBaseUtils.trace("update template slot values: " + cls2 + ", " + slot2 + " to " + list3);
        }
    }

    private static void updateTemplateFacets(Cls cls, Slot slot, KnowledgeBase knowledgeBase) {
        for (Facet facet : cls.getTemplateFacets(slot)) {
            KnowledgeBaseUtils.updateTemplateFacetValues(cls, slot, facet, knowledgeBase);
        }
    }

    private static void updateTemplateFacetValues(Cls cls, Slot slot, Facet facet, KnowledgeBase knowledgeBase) {
        Facet facet2;
        Slot slot2;
        Cls cls2;
        List list;
        List list2 = cls.getDirectTemplateFacetValues(slot, facet);
        List list3 = KnowledgeBaseUtils.getNewValues(list2, list = (cls2 = (Cls)KnowledgeBaseUtils.getFrame(cls, knowledgeBase)).getDirectTemplateFacetValues(slot2 = (Slot)KnowledgeBaseUtils.getFrame(slot, knowledgeBase), facet2 = (Facet)KnowledgeBaseUtils.getFrame(facet, knowledgeBase)), knowledgeBase);
        if (list3 != null) {
            cls2.setTemplateFacetValues(slot2, facet2, list3);
            KnowledgeBaseUtils.trace("update template facet values: " + cls2 + ", " + slot2 + ", " + facet2 + " to " + list3);
        }
    }

    private static void updateOwnSlotValues(Frame frame, Slot slot, KnowledgeBase knowledgeBase) {
        Slot slot2;
        Frame frame2;
        List list;
        List list2 = frame.getDirectOwnSlotValues(slot);
        List list3 = KnowledgeBaseUtils.getNewValues(list2, list = (frame2 = KnowledgeBaseUtils.getFrame(frame, knowledgeBase)).getDirectOwnSlotValues(slot2 = (Slot)KnowledgeBaseUtils.getFrame(slot, knowledgeBase)), knowledgeBase);
        if (list3 != null) {
            frame2.setOwnSlotValues(slot2, list3);
            KnowledgeBaseUtils.trace("update own slot values: " + frame2 + ", " + slot2 + " to " + list3);
        }
    }

    private static void trace(String string) {
    }
}

