/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protege.util.StringUtilities;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CacheMap {
    private static final int INIT_SIZE = 10007;
    private Map keyToReferenceMap = new HashMap(10007);
    private Map referenceToKeyMap = new HashMap(10007);
    private ReferenceQueue referenceQueue = new ReferenceQueue();
    private int maxSize;

    public CacheMap(int n) {
        this.maxSize = n;
    }

    public CacheMap() {
        this(Integer.MAX_VALUE);
    }

    private void pollQueue() {
        Reference reference;
        while ((reference = this.referenceQueue.poll()) != null) {
            Object v = this.referenceToKeyMap.remove(reference);
            this.keyToReferenceMap.remove(v);
        }
    }

    public Object get(Object object) {
        this.pollQueue();
        SoftReference softReference = (SoftReference)this.keyToReferenceMap.get(object);
        Object var3_3 = softReference == null ? null : softReference.get();
        return var3_3;
    }

    public void put(Object object, Object object2) {
        this.pollQueue();
        if (object2 == null) {
            this.keyToReferenceMap.put(object, object2);
        } else {
            SoftReference<Object> softReference = new SoftReference<Object>(object2, this.referenceQueue);
            this.keyToReferenceMap.put(object, softReference);
            this.referenceToKeyMap.put(softReference, object);
        }
        this.fixSize();
    }

    private void fixSize() {
        if (this.keyToReferenceMap.size() > this.maxSize) {
            Log.getLogger().info("removing elements from call cache");
            int n = 0;
            int n2 = this.maxSize / 5;
            Iterator iterator = this.keyToReferenceMap.entrySet().iterator();
            while (iterator.hasNext() && n++ < n2) {
                Map.Entry entry = iterator.next();
                Object v = this.keyToReferenceMap.get(entry);
                this.referenceToKeyMap.remove(v);
                iterator.remove();
            }
        }
    }

    public void remove(Object object) {
        this.pollQueue();
        Object v = this.keyToReferenceMap.remove(object);
        this.referenceToKeyMap.remove(v);
    }

    public void clear() {
        this.keyToReferenceMap.clear();
        this.referenceToKeyMap.clear();
        this.referenceQueue = new ReferenceQueue();
    }

    public Collection getKeys() {
        this.pollQueue();
        return new ArrayList(this.keyToReferenceMap.keySet());
    }

    public String toString() {
        this.pollQueue();
        return StringUtilities.getClassName(this);
    }
}

