/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protege.util;

import edu.stanford.smi.protege.util.FileUtilities;
import edu.stanford.smi.protege.util.StringUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class DirectoryClassLoader
extends URLClassLoader {
    private File directory;
    private static FilenameFilter jarFilter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return string.endsWith(".jar");
        }
    };

    public DirectoryClassLoader(File file, ClassLoader classLoader) {
        super(DirectoryClassLoader.getURLs(file), classLoader);
        this.directory = file;
    }

    private static URL[] getURLs(File file) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (file != null) {
            arrayList.add(FileUtilities.toURL(file));
            File[] fileArray = file.listFiles(jarFilter);
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    arrayList.add(FileUtilities.toURL(file2));
                }
            }
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public File getDirectory() {
        return this.directory;
    }

    public URL findResource(String string) {
        URL uRL = null;
        File file = new File(this.directory, string);
        if (file.exists()) {
            uRL = FileUtilities.toURL(file);
        }
        if (uRL == null) {
            uRL = super.findResource(string);
        }
        return uRL;
    }

    public String toString() {
        return StringUtilities.getClassName(this) + "(" + this.directory + ", " + this.getParent() + ")";
    }
}

