/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy;

import com.hp.hpl.jena.enhanced.EnhGraph;
import com.hp.hpl.jena.enhanced.EnhNode;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.ontology.tidy.Levels;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.impl.NTripleWriter;
import com.hp.hpl.jena.shared.BrokenException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.StringWriter;
import java.io.Writer;

public class SyntaxProblem {
    static Model emptyModel = ModelFactory.createDefaultModel();
    private Graph pgraph;
    private EnhNode pnode;
    protected final int level;
    private String shortDescription;
    private static RDFWriter defaultWriter = new NTripleWriter();
    private RDFWriter wtr = defaultWriter;

    static EnhNode inEmptyModel(Node node) {
        return ((EnhGraph)emptyModel).getNodeAs(node, RDFNode.class);
    }

    private SyntaxProblem(String string, EnhNode enhNode, Graph graph, int n) {
        if (enhNode == null && graph == null) {
            throw new BrokenException("Logic error in OWL Syntax Checker");
        }
        this.shortDescription = string;
        this.pnode = enhNode;
        this.pgraph = graph;
        this.level = n;
    }

    protected SyntaxProblem(String string, EnhNode enhNode, int n) {
        this(string, enhNode, null, n);
    }

    protected SyntaxProblem(String string, Node node, int n) {
        this(string, SyntaxProblem.inEmptyModel(node), null, n);
    }

    protected SyntaxProblem(String string, Graph graph, int n) {
        this(string, null, graph, n);
    }

    SyntaxProblem nodeInGraph(String string, Node node, Graph graph, int n) {
        Model model = ModelFactory.createDefaultModel();
        Graph graph2 = model.getGraph();
        SyntaxProblem.addAll(graph2, graph, node, null, null);
        SyntaxProblem.addAll(graph2, graph, null, node, null);
        SyntaxProblem.addAll(graph2, graph, null, null, node);
        return new SyntaxProblem(string, ((EnhGraph)model).getNodeAs(node, RDFNode.class), n);
    }

    private static void addAll(Graph graph, Graph graph2, Node node, Node node2, Node node3) {
        ExtendedIterator extendedIterator = graph2.find(node, node2, node3);
        while (extendedIterator.hasNext()) {
            graph.add((Triple)extendedIterator.next());
        }
    }

    public RDFWriter setWriter(RDFWriter rDFWriter) {
        RDFWriter rDFWriter2 = this.wtr;
        this.wtr = rDFWriter;
        return rDFWriter2;
    }

    public String longDescription() {
        Model model;
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("Not in OWL " + Levels.toString(this.level) + ": " + this.shortDescription + "\n");
        if (this.pnode != null) {
            Node node = this.pnode.asNode();
            stringWriter.write("Concerning ");
            if (node.isBlank()) {
                stringWriter.write("blank node");
            } else if (node.isURI()) {
                stringWriter.write("<" + node.getURI() + ">");
            } else {
                LiteralLabel literalLabel = node.getLiteral();
                String string = literalLabel.language();
                String string2 = literalLabel.getDatatypeURI();
                stringWriter.write("\"" + literalLabel.toString() + "\"" + (string != null && string.length() > 0 ? "@" + string : "") + (string2 == null ? "" : "^^<" + string2 + ">"));
            }
            model = (Model)this.pnode.getGraph();
            if (model == emptyModel) {
                stringWriter.write("\n");
            } else {
                stringWriter.write(" in:\n");
            }
        } else {
            stringWriter.write("Concerning sub-graph:\n");
            model = ModelFactory.createModelForGraph((Graph)this.pgraph);
        }
        this.wtr.write(model, (Writer)stringWriter, "never:never.never");
        return stringWriter.toString();
    }

    public EnhNode problemNode() {
        return this.pnode;
    }

    public String shortDescription() {
        return this.shortDescription;
    }

    public Graph problemSubGraph() {
        return this.pgraph;
    }

    public int getLevel() {
        return this.level;
    }
}

