/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.tidy.impl;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.tidy.impl.AbsChecker;
import com.hp.hpl.jena.ontology.tidy.impl.Blank;
import com.hp.hpl.jena.ontology.tidy.impl.CBuiltin;
import com.hp.hpl.jena.ontology.tidy.impl.CLit;
import com.hp.hpl.jena.ontology.tidy.impl.CNodeI;
import com.hp.hpl.jena.ontology.tidy.impl.CURIref;
import com.hp.hpl.jena.ontology.tidy.impl.Constants;
import com.hp.hpl.jena.ontology.tidy.impl.Grammar;
import com.hp.hpl.jena.ontology.tidy.impl.MinimalityInfo;
import com.hp.hpl.jena.ontology.tidy.impl.One;
import com.hp.hpl.jena.ontology.tidy.impl.OneTwoImpl;
import com.hp.hpl.jena.ontology.tidy.impl.SyntaxProblemImpl;
import com.hp.hpl.jena.ontology.tidy.impl.Two;

abstract class CNode
implements CNodeI,
Constants {
    final AbsChecker checker;
    final Node node;
    MinimalityInfo minimalityInfo;

    public static CNode create(Node node, AbsChecker absChecker) {
        CNode cNode = CNode.create1(node, absChecker);
        if (absChecker.extraInfo()) {
            cNode.minimalityInfo = absChecker.extraInfo() ? new MinimalityInfo(cNode) : null;
        }
        return cNode;
    }

    private static CNode create1(Node node, AbsChecker absChecker) {
        if (node.isLiteral()) {
            return new CLit(node, absChecker);
        }
        if (node.isURI()) {
            int n = Grammar.getBuiltinID(node.getURI());
            switch (n) {
                case -11: {
                    absChecker.addProblem(new SyntaxProblemImpl("Unrecognised OWL vocabulary", node, 0));
                    return new CURIref(node, absChecker);
                }
                case -12: {
                    absChecker.addProblem(new SyntaxProblemImpl("Unrecognised RDF vocabulary", node, 0));
                    return new CURIref(node, absChecker);
                }
                case -10: {
                    absChecker.addProblem(new SyntaxProblemImpl("Illadvised XSD datatype", node, 0));
                    return new CBuiltin(node, absChecker, 12);
                }
                case -1: {
                    return new CURIref(node, absChecker);
                }
            }
            if (n < 88) {
                return new CBuiltin(node, absChecker, n);
            }
            return new CURIref(node, absChecker, n);
        }
        return new OneTwoImpl(node, absChecker);
    }

    CNode(Node node, AbsChecker absChecker) {
        this.checker = absChecker;
        this.node = node;
    }

    public Node asNode() {
        return this.node;
    }

    public AbsChecker getChecker() {
        return this.checker;
    }

    public One asOne() {
        return (One)((Object)this);
    }

    public Two asTwo() {
        return (Two)((Object)this);
    }

    public Blank asBlank() {
        return (Blank)((Object)this);
    }

    public void addDisjoint(CNodeI cNodeI) {
        this.addDisjoint1(cNodeI);
        cNodeI.addDisjoint1(this);
    }

    public void addDisjoint1(CNodeI cNodeI) {
        this.getChecker().addDisjoint(this.asNode(), cNodeI.asNode());
    }

    void getSeen(Triple[] tripleArray) {
    }

    void setSeen(Triple[] tripleArray) {
    }
}

