/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.DataSet;
import com.hp.hpl.jena.query.DataSource;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.LogFactory;

public class DataSourceImpl
implements DataSource {
    Graph backgroundGraph = null;
    Model backgroundModel = null;
    Map namedGraphs = new HashMap();
    Map namedModels = new HashMap();

    public DataSourceImpl() {
    }

    public DataSourceImpl(DataSet dataSet) {
        if (!(dataSet instanceof DataSourceImpl)) {
            LogFactory.getLog((Class)DataSourceImpl.class).fatal((Object)"Clone DataSet: only DataSourceImpl supported");
            return;
        }
        DataSourceImpl dataSourceImpl = (DataSourceImpl)dataSet;
        this.namedGraphs.putAll(dataSourceImpl.namedGraphs);
        this.namedModels.putAll(dataSourceImpl.namedModels);
        this.backgroundGraph = dataSourceImpl.backgroundGraph;
        this.backgroundModel = dataSourceImpl.backgroundModel;
    }

    public DataSourceImpl(Model model) {
        this();
        this.setModel(model);
    }

    public Model getModel() {
        return this.backgroundModel;
    }

    public Graph getGraph() {
        return this.backgroundGraph;
    }

    public Model getNamedModel(String string) {
        return (Model)this.namedModels.get(string);
    }

    public Graph getNamedGraph(String string) {
        return (Graph)this.namedGraphs.get(string);
    }

    public Iterator listNames() {
        return this.namedGraphs.keySet().iterator();
    }

    public Iterator listNamedModels() {
        return this.namedModels.values().iterator();
    }

    public Iterator listNamedGraphs() {
        return this.namedGraphs.values().iterator();
    }

    public void close() {
        Iterator iterator = this.listNamedModels();
        while (iterator.hasNext()) {
            Model model = (Model)iterator.next();
            model.close();
        }
        this.namedGraphs.clear();
        this.namedModels.clear();
        if (this.backgroundGraph != null) {
            this.backgroundGraph.close();
        }
        if (this.backgroundModel != null) {
            this.backgroundModel.close();
        }
    }

    public void setModel(Model model) {
        this.backgroundGraph = model.getGraph();
        this.backgroundModel = model;
    }

    public void setGraph(Graph graph) {
        this.backgroundGraph = graph;
        this.backgroundModel = ModelFactory.createModelForGraph((Graph)graph);
    }

    public void addNamedModel(String string, Model model) throws LabelExistsException {
        this.add(string, model.getGraph(), model);
    }

    public void addNamedGraph(String string, Graph graph) throws LabelExistsException {
        this.add(string, graph, ModelFactory.createModelForGraph((Graph)graph));
    }

    private void add(String string, Graph graph, Model model) throws LabelExistsException {
        if (this.namedGraphs.containsKey(string)) {
            throw new LabelExistsException("URI: " + string);
        }
        this.namedGraphs.put(string, graph);
        this.namedModels.put(string, model);
    }

    public void removeNamedModel(String string) {
        this.removeNamedGraph(string);
    }

    public void removeNamedGraph(String string) {
        this.namedGraphs.remove(string);
        this.namedModels.remove(string);
    }

    public void replaceNamedModel(String string, Model model) {
        this.removeNamedModel(string);
        this.addNamedModel(string, model);
    }

    public void replaceNamedGraph(String string, Graph graph) {
        this.removeNamedGraph(string);
        this.addNamedGraph(string, graph);
    }

    public String toString() {
        String string = "{";
        string = this.getGraph() == null ? string + "<null>" : string + "[" + this.getGraph().size() + "]";
        Iterator iterator = this.listNames();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            string = string + ", (" + string2 + ", [" + this.getNamedGraph(string2).size() + "])";
        }
        string = string + "}";
        return string;
    }
}

