/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.serializer.FormatterARQ;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterSPARQLalt;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.QuerySerializer;
import com.hp.hpl.jena.query.serializer.QuerySerializerAbstract;
import com.hp.hpl.jena.query.serializer.QuerySerializerPlain;
import com.hp.hpl.jena.query.serializer.QuerySerializerXML;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Serializer {
    static final int BLOCK_INDENT = 2;
    private static Log log = LogFactory.getLog((Class)Serializer.class);

    public static void serialize(Query query2, OutputStream outputStream) {
        Serializer.serialize(query2, outputStream, null);
    }

    public static void serialize(Query query2, OutputStream outputStream, String string) {
        IndentedWriter indentedWriter = new IndentedWriter(outputStream);
        Serializer.serialize(query2, indentedWriter, string);
        indentedWriter.flush();
        try {
            outputStream.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void serialize(Query query2, IndentedLineBuffer indentedLineBuffer) {
        String string = query2.getSyntax();
        if (string == null) {
            string = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        Serializer.serialize(query2, indentedLineBuffer, string);
    }

    public static void serialize(Query query2, IndentedLineBuffer indentedLineBuffer, String string) {
        Serializer.serialize(query2, indentedLineBuffer.getIndentedWriter(), string);
    }

    public static void serialize(Query query2, IndentedWriter indentedWriter) {
        String string = query2.getSyntax();
        if (string == null) {
            string = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        Serializer.serialize(query2, indentedWriter, string);
    }

    public static void serialize(Query query2, IndentedWriter indentedWriter, String string) {
        if (string == null) {
            string = "http://jena.hpl.hp.com/2003/07/query/SPARQL";
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/ARQ")) {
            Serializer.serializeARQ(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/RDQL")) {
            Serializer.serializeRDQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL")) {
            Serializer.serializeSPARQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-X")) {
            Serializer.serializeSPARQL_X(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL-alt")) {
            Serializer.serializeSPARQL_alt(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/SPARQL")) {
            Serializer.serializeSPARQL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/N3QL")) {
            Serializer.serializeN3QL(query2, indentedWriter);
            indentedWriter.flush();
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/abstract")) {
            Serializer.serializeAbstract(query2, indentedWriter);
            return;
        }
        if (string.equals("http://jena.hpl.hp.com/2003/07/query/debug")) {
            Serializer.serializePlain(query2, indentedWriter);
            return;
        }
        log.warn((Object)("Unknown syntax: " + string));
    }

    public static void serializeARQ(Query query2, IndentedWriter indentedWriter) {
        Serializer.serializeSPARQL(query2, indentedWriter);
    }

    private static void serializeARQ(Query query2, SerializationContext serializationContext, IndentedWriter indentedWriter, FormatterBase formatterBase) {
        QuerySerializer querySerializer = new QuerySerializer(indentedWriter, serializationContext, (FormatterTemplate)formatterBase, (FormatterElement)formatterBase);
        query2.visit(querySerializer);
    }

    public static void serializeSPARQL(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        Serializer.serializeARQ(query2, serializationContext, indentedWriter, new FormatterARQ(indentedWriter, serializationContext));
    }

    public static void serializeSPARQL_X(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        QuerySerializerXML querySerializerXML = new QuerySerializerXML(indentedWriter, serializationContext);
        query2.visit(querySerializerXML);
    }

    public static void serializeSPARQL_alt(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        Serializer.serializeARQ(query2, serializationContext, indentedWriter, new FormatterSPARQLalt(indentedWriter, serializationContext));
    }

    public static void serializeRDQL(Query query2, IndentedWriter indentedWriter) {
        log.warn((Object)"# unparseRDQL: Not implemented - Native syntax instead");
        Serializer.serializeARQ(query2, indentedWriter);
    }

    public static void serializeAbstract(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        QuerySerializerAbstract querySerializerAbstract = new QuerySerializerAbstract(indentedWriter, serializationContext);
        query2.visit(querySerializerAbstract);
    }

    public static void serializePlain(Query query2, IndentedWriter indentedWriter) {
        SerializationContext serializationContext = new SerializationContext(query2, query2.getPrefixMapping(), null);
        QuerySerializerPlain querySerializerPlain = new QuerySerializerPlain(indentedWriter, serializationContext);
        query2.visit(querySerializerPlain);
    }

    public static void serializeN3QL(Query query2, IndentedWriter indentedWriter) {
        throw new UnsupportedOperationException("Not implemented: Formatting a query in N3QL syntax");
    }
}

