/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Delta;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestDelta
extends GraphTestBase {
    public TestDelta(String string) {
        super(string);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDelta.class);
    }

    public void testDelta() {
        Graph graph = TestDelta.graphWith("x R y");
        TestDelta.assertContains("x", "x R y", graph);
        graph.delete(TestDelta.triple("x R y"));
        this.assertOmits("x", graph, "x R y");
        Graph graph2 = TestDelta.graphWith("x R y; p S q; I like cheese; pins pop balloons");
        Graph graph3 = TestDelta.graphWith("x R y; p S q; I like cheese; pins pop balloons");
        Delta delta = new Delta(graph2);
        TestDelta.assertContainsAll("Delta", delta, "x R y; p S q; I like cheese; pins pop balloons");
        TestDelta.assertContainsAll("Delta", graph2, "x R y; p S q; I like cheese; pins pop balloons");
        delta.add(TestDelta.triple("pigs fly winglessly"));
        delta.delete(TestDelta.triple("I like cheese"));
        TestDelta.assertContainsAll("changed Delta", delta, "x R y; p S q; pins pop balloons; pigs fly winglessly");
        this.assertOmits("changed delta", delta, "I like cheese");
        TestDelta.assertContains("delta additions", "pigs fly winglessly", delta.getAdditions());
        this.assertOmits("delta additions", delta.getAdditions(), "I like cheese");
        TestDelta.assertContains("delta deletions", "I like cheese", delta.getDeletions());
        this.assertOmits("delta deletions", delta.getDeletions(), "pigs fly winglessly");
    }
}

