/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.query.Expression;
import com.hp.hpl.jena.graph.query.IndexValues;
import com.hp.hpl.jena.graph.query.Valuator;
import com.hp.hpl.jena.graph.query.VariableIndexes;
import com.hp.hpl.jena.shared.JenaException;

public abstract class Dyadic
extends Expression.Application {
    protected Expression L;
    protected Expression R;
    protected String F;

    public Dyadic(Expression expression, String string, Expression expression2) {
        this.L = expression;
        this.F = string;
        this.R = expression2;
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int n) {
        return n == 0 ? this.L : this.R;
    }

    public String getFun() {
        return this.F;
    }

    public Object evalObject(Object object, Object object2) {
        return this.evalBool(object, object2) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean evalBool(Object object, Object object2) {
        Object object3 = this.evalObject(object, object2);
        if (object3 instanceof Boolean) {
            return (Boolean)object3;
        }
        throw new JenaException("not Boolean: " + object3);
    }

    public Valuator prepare(VariableIndexes variableIndexes) {
        final Valuator valuator = this.L.prepare(variableIndexes);
        final Valuator valuator2 = this.R.prepare(variableIndexes);
        return new Valuator(){

            public boolean evalBool(IndexValues indexValues) {
                return (Boolean)this.evalObject(indexValues);
            }

            public Object evalObject(IndexValues indexValues) {
                return Dyadic.this.evalObject(valuator.evalObject(indexValues), valuator2.evalObject(indexValues));
            }
        };
    }

    public String toString() {
        return this.L.toString() + " " + this.F + " " + this.R.toString();
    }

    public static Expression and(Expression expression, Expression expression2) {
        return new Dyadic(expression, "urn:x-jena:expr:AND", expression2){

            public boolean evalBool(Object object, Object object2) {
                return (Boolean)object != false && (Boolean)object2 != false;
            }
        };
    }
}

