/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.impl;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.GraphMem;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.impl.BindingStack;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BFRuleContext
implements RuleContext {
    protected BindingStack env;
    protected Rule rule;
    protected ForwardRuleInfGraphI graph;
    protected List stack;
    protected List pending;
    protected List deletesPending = new ArrayList();
    protected Graph pendingCache;
    protected static Log logger = LogFactory.getLog((Class)BFRuleContext.class);

    public BFRuleContext(ForwardRuleInfGraphI forwardRuleInfGraphI) {
        this.graph = forwardRuleInfGraphI;
        this.env = new BindingStack();
        this.stack = new ArrayList();
        this.pending = new ArrayList();
        this.pendingCache = new GraphMem();
    }

    public BindingEnvironment getEnv() {
        return this.env;
    }

    public BindingStack getEnvStack() {
        return this.env;
    }

    public InfGraph getGraph() {
        return this.graph;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void addTriple(Triple triple) {
        if (this.graph.shouldTrace()) {
            if (this.rule != null) {
                logger.debug((Object)("Adding to stack (" + this.rule.toShortString() + "): " + PrintUtil.print(triple)));
            } else {
                logger.debug((Object)("Adding to stack : " + PrintUtil.print(triple)));
            }
        }
        this.stack.add(triple);
    }

    public void add(Triple triple) {
        if (this.graph.shouldTrace()) {
            if (this.rule != null) {
                logger.debug((Object)("Adding to pending (" + this.rule.toShortString() + "): " + PrintUtil.print(triple)));
            } else {
                logger.debug((Object)("Adding to pending : " + PrintUtil.print(triple)));
            }
        }
        this.pending.add(triple);
    }

    public void flushPending() {
        Triple triple;
        Iterator iterator = this.pending.iterator();
        while (iterator.hasNext()) {
            triple = (Triple)iterator.next();
            this.stack.add(triple);
            this.graph.addDeduction(triple);
            iterator.remove();
        }
        this.pending.clear();
        iterator = this.deletesPending.iterator();
        while (iterator.hasNext()) {
            triple = (Triple)iterator.next();
            this.graph.delete(triple);
        }
        this.deletesPending.clear();
    }

    public boolean contains(Triple triple) {
        return this.contains(triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    public boolean contains(Node node, Node node2, Node node3) {
        ClosableIterator closableIterator = this.find(node, node2, node3);
        boolean bl = closableIterator.hasNext();
        closableIterator.close();
        return bl;
    }

    public ClosableIterator find(Node node, Node node2, Node node3) {
        return this.graph.findDataMatches(node, node2, node3);
    }

    public Triple getNextTriple() {
        if (this.stack.size() > 0) {
            Triple triple = (Triple)this.stack.remove(this.stack.size() - 1);
            return triple;
        }
        return null;
    }

    public void resetEnv() {
        this.env.reset();
    }

    public void silentAdd(Triple triple) {
        this.graph.silentAdd(triple);
    }

    public void remove(Triple triple) {
        this.deletesPending.add(triple);
    }
}

