/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.jena.importer.tests;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.jena.importer.tests.AbstractOWLImporterTestCase;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;

public class ImportClsesTestCase
extends AbstractOWLImporterTestCase {
    public void testImportAbstractNamedCls() throws Exception {
        this.loadRemoteOntologyWithProtegeMetadataOntology();
        OWLNamedClass oldCls = this.owlModel.createOWLNamedClass("Cls");
        oldCls.setAbstract(true);
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        ImportClsesTestCase.assertTrue((boolean)newCls.isAbstract());
    }

    public void testImportSimpleOWLNamedClass() {
        OWLNamedClass oldCls = this.owlModel.createOWLNamedSubclass("Cls", this.owlModel.getOWLThingClass());
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldCls.getName());
        ImportClsesTestCase.assertNotNull((Object)newCls);
        ImportClsesTestCase.assertEquals((int)1, (int)newCls.getDirectSuperclassCount());
        ImportClsesTestCase.assertEquals((Object)kb.getRootCls(), newCls.getDirectSuperclasses().iterator().next());
    }

    public void testImportSuperclasses() {
        OWLNamedClass parentCls = this.owlModel.createOWLNamedSubclass("ParentCls", this.owlModel.getOWLThingClass());
        OWLNamedClass childCls = this.owlModel.createOWLNamedSubclass("ChildCls", parentCls);
        KnowledgeBase kb = this.runOWLImporter();
        Cls newParentCls = kb.getCls(parentCls.getName());
        ImportClsesTestCase.assertEquals((int)1, (int)newParentCls.getDirectSuperclassCount());
        ImportClsesTestCase.assertEquals((Object)kb.getRootCls(), newParentCls.getDirectSuperclasses().iterator().next());
        Cls newChildCls = kb.getCls(childCls.getName());
        ImportClsesTestCase.assertEquals((int)1, (int)newChildCls.getDirectSuperclassCount());
        ImportClsesTestCase.assertEquals((Object)newParentCls, newChildCls.getDirectSuperclasses().iterator().next());
    }

    public void testImportTemplateSlots() {
        OWLNamedClass oldClass = this.owlModel.createOWLNamedClass("Cls");
        OWLObjectProperty objectSlot = this.owlModel.createOWLObjectProperty("objectSlot");
        OWLDatatypeProperty datatypeSlot = this.owlModel.createOWLDatatypeProperty("datatypeSlot", this.owlModel.getXSDstring());
        objectSlot.setDomain(oldClass);
        datatypeSlot.setDomain(oldClass);
        KnowledgeBase kb = this.runOWLImporter();
        Cls newCls = kb.getCls(oldClass.getName());
        ImportClsesTestCase.assertSize(2, newCls.getDirectTemplateSlots());
        ImportClsesTestCase.assertContains((Object)kb.getSlot(objectSlot.getName()), newCls.getDirectTemplateSlots());
        ImportClsesTestCase.assertContains((Object)kb.getSlot(datatypeSlot.getName()), newCls.getDirectTemplateSlots());
    }
}

