/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.impl;

import edu.stanford.smi.protege.model.FrameID;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.impl.DefaultRDFProperty;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public abstract class AbstractOWLProperty
extends DefaultRDFProperty
implements OWLProperty {
    public AbstractOWLProperty(KnowledgeBase kb, FrameID id) {
        super(kb, id);
    }

    AbstractOWLProperty() {
    }

    public ImageIcon getBaseImageIcon() {
        return OWLIcons.getImageIcon(this.getIconName());
    }

    public Icon getIcon() {
        String iconName = this.getIconName();
        if (this.isEditable()) {
            return OWLIcons.getImageIcon(iconName);
        }
        if (this.isAnnotationProperty()) {
            return OWLIcons.getReadOnlyAnnotationPropertyIcon(OWLIcons.getImageIcon(iconName));
        }
        return OWLIcons.getReadOnlyPropertyIcon(OWLIcons.getImageIcon(iconName));
    }

    public String getIconName() {
        String iconName;
        String string = iconName = this.isObjectProperty() ? "OWLObjectProperty" : "OWLDatatypeProperty";
        if (this.isAnnotationProperty()) {
            iconName = "Annotation" + iconName;
        }
        return iconName;
    }

    public boolean isInverseFunctional() {
        RDFSNamedClass metaclass = this.getOWLModel().getRDFSNamedClass("owl:InverseFunctionalProperty");
        if (this.hasProtegeType(metaclass)) {
            return true;
        }
        for (RDFProperty property : this.getSuperproperties(false)) {
            if (!(property instanceof OWLProperty) || !((OWLProperty)property).isInverseFunctional()) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectProperty() {
        return this.getKnowledgeBase().getSlot(this.getName()) instanceof OWLObjectProperty;
    }

    public void setAnnotationProperty(boolean value) {
        this.updateRDFType(value, (RDFSClass)this.getKnowledgeBase().getCls("owl:AnnotationProperty"));
    }

    public void setEquivalentProperties(Collection slots) {
        RDFProperty equivalentClassesSlot = this.getOWLModel().getOWLEquivalentPropertyProperty();
        this.setOwnSlotValues(equivalentClassesSlot, slots);
    }

    public void setInverseFunctional(boolean value) {
        RDFSNamedClass metaclass = this.getOWLModel().getRDFSNamedClass("owl:InverseFunctionalProperty");
        this.updateRDFType(value, metaclass);
    }
}

