/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.model.util;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLCardinalityBase;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class DLExpressivityChecker
extends OWLModelVisitorAdapter {
    private OWLModel owlModel;
    private Set constructors;
    public static final String FL0 = "FL0";
    public static final String FL_MINUS = "FL-";
    public static final String AL = "AL";
    public static final String C = "C";
    public static final String TRAN_ROLES = "Tran";
    public static final String E = "E";
    public static final String U = "U";
    public static final String I = "I";
    public static final String O = "O";
    public static final String N = "N";
    public static final String Q = "Q";
    public static final String F = "F";
    public static final String H = "H";
    public static final String DATATYPE = "(D)";
    public static final String S = "S";

    public DLExpressivityChecker(OWLModel owlModel) {
        this.owlModel = owlModel;
        this.constructors = new TreeSet();
    }

    public void check() {
        this.constructors = new TreeSet();
        this.constructors.add(FL0);
        for (RDFResource res : this.owlModel.getRDFResources()) {
            if (res.isSystem()) continue;
            res.accept(this);
        }
        this.tidy();
    }

    public String getDLName() {
        Collection langFeatures = this.getSortedName();
        String s = "";
        Iterator it = langFeatures.iterator();
        while (it.hasNext()) {
            s = String.valueOf(s) + it.next() + " ";
        }
        return s.trim();
    }

    public Collection getDL() {
        return this.getSortedName();
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom owlAllValuesFrom) {
        this.constructors.add(FL0);
    }

    public void visitOWLCardinality(OWLCardinality owlCardinality) {
        this.processCardinality(owlCardinality);
    }

    public void visitOWLComplementClass(OWLComplementClass owlComplementClass) {
        this.constructors.add(AL);
        RDFSClass complementedCls = owlComplementClass.getComplement();
        if (complementedCls instanceof OWLNamedClass) {
            if (!this.isAtomic((OWLNamedClass)complementedCls)) {
                this.constructors.add(C);
            } else {
                this.constructors.add(C);
            }
        }
    }

    public void visitOWLDataRange(OWLDataRange owlDataRange) {
        this.constructors.add(DATATYPE);
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty owlDatatypeProperty) {
        this.constructors.add(DATATYPE);
        if (owlDatatypeProperty.isFunctional()) {
            this.constructors.add(F);
        }
        if (owlDatatypeProperty.getSuperproperties(false).size() > 0) {
            this.constructors.add(H);
        }
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass owlEnumeratedClass) {
        this.constructors.add(AL);
        this.constructors.add(O);
    }

    public void visitOWLHasValue(OWLHasValue owlHasValue) {
        this.constructors.add(AL);
        this.constructors.add(E);
        this.constructors.add(O);
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass owlIntersectionClass) {
        this.constructors.add(FL0);
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality owlMaxCardinality) {
        this.processCardinality(owlMaxCardinality);
    }

    public void visitOWLMinCardinality(OWLMinCardinality owlMinCardinality) {
        this.processCardinality(owlMinCardinality);
    }

    private void processCardinality(OWLCardinalityBase cardinalityBase) {
        this.constructors.add(AL);
        if (!cardinalityBase.getQualifier().equals(this.owlModel.getOWLThingClass())) {
            this.constructors.add(Q);
        } else {
            this.constructors.add(N);
        }
    }

    public void visitOWLNamedClass(OWLNamedClass owlNamedClass) {
        this.constructors.add(FL0);
        Collection disjointClasses = owlNamedClass.getDisjointClasses();
        if (disjointClasses.size() > 0) {
            this.constructors.add(AL);
            for (RDFSClass cls : disjointClasses) {
                if (cls instanceof OWLNamedClass) {
                    if (this.isAtomic((OWLNamedClass)cls)) continue;
                    this.constructors.add(C);
                    break;
                }
                this.constructors.add(C);
                break;
            }
        }
    }

    public void visitOWLObjectProperty(OWLObjectProperty owlObjectProperty) {
        this.constructors.add(AL);
        if (owlObjectProperty.isFunctional()) {
            this.constructors.add(F);
        }
        if (owlObjectProperty.getSuperproperties(false).size() > 0) {
            this.constructors.add(H);
        }
        if (owlObjectProperty.getInverseProperty() != null) {
            this.constructors.add(I);
        }
        if (owlObjectProperty.isSymmetric()) {
            this.constructors.add(I);
        }
        if (owlObjectProperty.isTransitive()) {
            this.constructors.add(TRAN_ROLES);
        }
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom someValuesFrom) {
        if (someValuesFrom.getFiller().equals(this.owlModel.getOWLThingClass())) {
            this.constructors.add(FL_MINUS);
        } else {
            this.constructors.add(E);
            this.constructors.add(AL);
        }
    }

    public void visitOWLUnionClass(OWLUnionClass owlUnionClass) {
        this.constructors.add(AL);
        this.constructors.add(U);
    }

    private Collection getSortedName() {
        TreeSet ts = new TreeSet(new LangFeatureComparator());
        ts.addAll(this.constructors);
        return ts;
    }

    public String toString() {
        String s = "";
        Iterator it = this.constructors.iterator();
        while (it.hasNext()) {
            s = String.valueOf(s) + it.next() + " ";
        }
        return s.trim();
    }

    private boolean isAtomic(OWLNamedClass cls) {
        Collection superClses = cls.getSuperclasses(false);
        superClses.remove(this.owlModel.getOWLThingClass());
        if (superClses.size() > 0) {
            return false;
        }
        return cls.getDisjointClasses().size() == 0;
    }

    private void tidy() {
        if (this.constructors.contains(FL_MINUS)) {
            this.constructors.remove(FL0);
        }
        if (this.constructors.contains(AL)) {
            this.constructors.remove(FL_MINUS);
            this.constructors.remove(FL0);
        }
        if (this.constructors.contains(E) && this.constructors.contains(U)) {
            this.constructors.add(C);
            this.constructors.remove(E);
            this.constructors.remove(U);
        } else if (this.constructors.contains(C)) {
            this.constructors.remove(E);
            this.constructors.remove(U);
        }
        if (this.constructors.contains(N)) {
            this.constructors.remove(F);
        }
        if (this.constructors.contains(Q)) {
            this.constructors.remove(N);
        }
        if (this.constructors.contains(AL) && this.constructors.contains(C) && this.constructors.contains(TRAN_ROLES)) {
            this.constructors.remove(AL);
            this.constructors.remove(C);
            this.constructors.remove(TRAN_ROLES);
            this.constructors.add(S);
        }
    }

    private class LangFeatureComparator
    implements Comparator {
        private List ORDER = Arrays.asList("AL", "C", "U", "E", "S", "H", "O", "I", "F", "N", "Q", "(D)", "Tran");

        private LangFeatureComparator() {
        }

        public int compare(Object o1, Object o2) {
            return this.ORDER.indexOf(o1) - this.ORDER.indexOf(o2);
        }
    }
}

