/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.classform.component.property;

import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.ui.classform.component.property.PropertyFormTable;
import edu.stanford.smi.protegex.owl.ui.existential.Existential;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeleteRowAction
extends AbstractAction {
    private PropertyFormTable table;

    public DeleteRowAction(PropertyFormTable table) {
        super("Delete selected rows", OWLIcons.getDeleteIcon());
        this.table = table;
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DeleteRowAction.this.updateEnabled();
            }
        });
        this.updateEnabled();
    }

    public void actionPerformed(ActionEvent e) {
        OWLObjectProperty prop = (OWLObjectProperty)this.table.getTableModel().getProperty();
        OWLNamedClass subject = this.table.getTableModel().getNamedClass();
        OWLNamedClass filler = (OWLNamedClass)this.table.getSelectedResource();
        OWLSomeValuesFrom restr = Existential.getDirectExistentialRelation(subject, prop, filler);
        subject.removeSuperclass(restr);
    }

    public boolean isEnabledFor(int[] selectedRows) {
        return selectedRows.length > 0;
    }

    private void updateEnabled() {
        int[] selectedRows = this.table.getSelectedRows();
        this.setEnabled(this.isEnabledFor(selectedRows));
    }
}

