/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.conditions.tests;

import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.ui.conditions.ConditionsTableModel;
import edu.stanford.smi.protegex.owl.ui.conditions.tests.AbstractConditionsTableTestCase;
import java.net.URI;

public class ImportTestCase
extends AbstractConditionsTableTestCase {
    private OWLObjectProperty hasChildrenProperty;
    private OWLNamedClass parentCls;
    private OWLNamedClass personCls;
    private ConditionsTableModel tableModel;
    public static final String FILE = "http://protege.stanford.edu/plugins/owl/testdata/importer.owl";

    public void testAddingNamedClassToImportedClass() throws Exception {
        this.initTestData();
        ImportTestCase.assertFalse((boolean)this.tableModel.isAddEnabledAt(0));
        ImportTestCase.assertFalse((boolean)this.tableModel.isAddEnabledAt(1));
        ImportTestCase.assertTrue((boolean)this.tableModel.isAddEnabledAt(2));
        ImportTestCase.assertTrue((boolean)this.tableModel.isAddEnabledAt(3));
        ImportTestCase.assertTrue((boolean)this.tableModel.isAddEnabledAt(4));
        ImportTestCase.assertFalse((boolean)this.tableModel.isAddEnabledAt(5));
        ImportTestCase.assertFalse((boolean)this.tableModel.isAddEnabledAt(6));
    }

    public void testAddingAnonymousClassToImportedClass() throws Exception {
        this.initTestData();
        ImportTestCase.assertFalse((boolean)this.tableModel.isCreateEnabledAt(0));
        ImportTestCase.assertFalse((boolean)this.tableModel.isCreateEnabledAt(1));
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(2));
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(3));
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(4));
        ImportTestCase.assertFalse((boolean)this.tableModel.isCreateEnabledAt(5));
        ImportTestCase.assertFalse((boolean)this.tableModel.isCreateEnabledAt(6));
    }

    public void testDeletingFromImportedClass() throws Exception {
        this.initTestData();
        ImportTestCase.assertFalse((boolean)this.tableModel.isDeleteEnabledFor(this.tableModel.getClass(1)));
        ImportTestCase.assertFalse((boolean)this.tableModel.isDeleteEnabledFor(this.tableModel.getClass(3)));
        ImportTestCase.assertFalse((boolean)this.tableModel.isDeleteEnabledFor(this.tableModel.getClass(4)));
        ImportTestCase.assertFalse((boolean)this.tableModel.isDeleteEnabledFor(this.tableModel.getClass(6)));
    }

    public void testAddSuperclasses() throws Exception {
        this.initTestData();
        OWLSomeValuesFrom testClass = this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.hasChildrenProperty, this.personCls);
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(2));
        this.tableModel.addRow(testClass, 2);
        this.assertTableModelStructure(this.tableModel, new Object[]{"SUFFICIENT", OWLMinCardinality.class, NECESSARY, this.personCls, OWLAllValuesFrom.class, testClass, INHERITED, OWLMaxCardinality.class});
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(3));
        ImportTestCase.assertFalse((boolean)this.tableModel.isDeleteEnabledFor(this.tableModel.getClass(4)));
        ImportTestCase.assertTrue((boolean)this.tableModel.isDeleteEnabledFor(testClass));
        this.tableModel.addEmptyRow(3);
        ImportTestCase.assertTrue((boolean)this.tableModel.isCellEditable(6, 0));
    }

    public void testAddAndRemoveEquivalentClass() throws Exception {
        this.initTestData();
        OWLSomeValuesFrom testClass = this.owlModel.createOWLSomeValuesFrom((RDFProperty)this.hasChildrenProperty, this.personCls);
        ImportTestCase.assertFalse((boolean)this.tableModel.isCreateEnabledAt(0));
        this.parentCls.addEquivalentClass(testClass);
        this.assertTableModelStructure(this.tableModel, new Object[]{"SUFFICIENT", testClass, "SUFFICIENT", OWLMinCardinality.class, NECESSARY, this.personCls, OWLAllValuesFrom.class, INHERITED, OWLMaxCardinality.class});
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(1));
        ImportTestCase.assertTrue((boolean)this.tableModel.isDeleteEnabledFor(testClass));
        this.tableModel.addEmptyRow(1);
        ImportTestCase.assertTrue((boolean)this.tableModel.isCellEditable(2, 0));
    }

    private void initTestData() throws Exception {
        this.loadTestOntology(new URI(FILE));
        this.personCls = this.owlModel.getOWLNamedClass("imported:Person");
        this.parentCls = this.owlModel.getOWLNamedClass("imported:Parent");
        this.hasChildrenProperty = (OWLObjectProperty)this.owlModel.getSlot("imported:hasChildren");
        ImportTestCase.assertNotNull((Object)this.personCls);
        ImportTestCase.assertNotNull((Object)this.parentCls);
        ImportTestCase.assertNotNull((Object)this.hasChildrenProperty);
        this.tableModel = this.getTableModel(this.parentCls);
        this.assertTableModelStructure(this.tableModel, new Object[]{"SUFFICIENT", OWLMinCardinality.class, NECESSARY, this.personCls, OWLAllValuesFrom.class, INHERITED, OWLMaxCardinality.class});
    }

    public void testAddNamedClassToImportedDefinedClass() throws Exception {
        this.loadRemoteOntology("importTravel.owl");
        OWLNamedClass c = this.owlModel.getOWLNamedClass("travel:BackpackersDestination");
        ImportTestCase.assertNotNull((Object)c);
        this.tableModel = this.getTableModel(c);
        this.assertTableModelStructure(this.tableModel, new Object[]{"SUFFICIENT", this.owlModel.getOWLNamedClass("travel:Destination"), OWLSomeValuesFrom.class, OWLSomeValuesFrom.class, NECESSARY});
        ImportTestCase.assertFalse((boolean)this.tableModel.isAddEnabledAt(0));
        ImportTestCase.assertFalse((boolean)this.tableModel.isAddEnabledAt(1));
        ImportTestCase.assertTrue((boolean)this.tableModel.isAddEnabledAt(4));
        ImportTestCase.assertFalse((boolean)this.tableModel.isCreateEnabledAt(0));
        ImportTestCase.assertFalse((boolean)this.tableModel.isCreateEnabledAt(1));
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(4));
    }

    public void testAddNamedClassToImportedPrimitiveClass() throws Exception {
        this.loadRemoteOntology("importTravel.owl");
        OWLNamedClass c = this.owlModel.getOWLNamedClass("travel:Activity");
        ImportTestCase.assertNotNull((Object)c);
        this.tableModel = this.getTableModel(c);
        this.assertTableModelStructure(this.tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing});
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(0));
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(1));
        ImportTestCase.assertTrue((boolean)this.tableModel.isCreateEnabledAt(2));
        ImportTestCase.assertTrue((boolean)this.tableModel.isAddEnabledAt(0));
        ImportTestCase.assertTrue((boolean)this.tableModel.isAddEnabledAt(1));
        ImportTestCase.assertTrue((boolean)this.tableModel.isAddEnabledAt(2));
        OWLNamedClass a = this.owlModel.getOWLNamedClass("travel:Accommodation");
        ImportTestCase.assertNotNull((Object)a);
        this.tableModel.addRow(a, 2);
        this.assertTableModelStructure(this.tableModel, new Object[]{"SUFFICIENT", NECESSARY, this.owlThing, a});
        ImportTestCase.assertTrue((boolean)this.tableModel.isRemoveEnabledFor(3));
        ImportTestCase.assertTrue((boolean)this.tableModel.isDeleteEnabledFor(a));
    }
}

