/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSLiteral;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import edu.stanford.smi.protegex.owl.ui.widget.TimePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class OWLTimeWidget
extends AbstractPropertyWidget
implements TimePanel.Listener {
    private Action deleteAction = new AbstractAction("Delete value", OWLIcons.getDeleteIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLTimeWidget.this.timePanel.clear();
            OWLTimeWidget.this.timeChanged(OWLTimeWidget.this.timePanel);
        }
    };
    private LabeledComponent lc;
    private Action nowAction = new AbstractAction("Set to now", OWLIcons.getAddIcon()){

        public void actionPerformed(ActionEvent e) {
            OWLTimeWidget.this.timePanel.setTime(new Date());
            OWLTimeWidget.this.timeChanged(OWLTimeWidget.this.timePanel);
        }
    };
    private TimePanel timePanel;

    public void initialize() {
        this.timePanel = new TimePanel(this);
        this.setLayout(new BorderLayout());
        this.lc = new LabeledComponent(this.getRDFProperty().getBrowserText(), (Component)this.timePanel);
        this.lc.addHeaderButton(this.nowAction);
        this.lc.addHeaderButton(this.deleteAction);
        this.add("Center", (Component)this.lc);
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        this.nowAction.setEnabled(b);
        this.deleteAction.setEnabled(b);
    }

    public void setInstance(Instance newInstance) {
        super.setInstance(newInstance);
        if (newInstance != null) {
            this.setTimePanelValue();
        }
    }

    private void setTimePanelValue() {
        RDFProperty property;
        RDFResource resource = this.getEditedResource();
        Object value = resource.getPropertyValue(property = this.getRDFProperty());
        if (value == null) {
            this.timePanel.clear();
        } else {
            this.timePanel.setTime(value.toString());
        }
    }

    public void timeChanged(TimePanel timePanel) {
        RDFResource resource = this.getEditedResource();
        RDFProperty property = this.getRDFProperty();
        if (!timePanel.isNull()) {
            String newDate = timePanel.getTime();
            RDFSLiteral literal = this.getOWLModel().createRDFSLiteral(newDate, this.getOWLModel().getRDFSDatatypeByURI(XSDDatatype.XSDtime.getURI()));
            resource.setPropertyValue(property, literal);
        } else {
            resource.setPropertyValues(property, Collections.EMPTY_LIST);
        }
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(OWLTimeWidget.class, cls, slot);
    }
}

