/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class XMLWriterNamespaceManager {
    private Map prefixNamespaceMap = new HashMap();
    private Map namespacePrefixMap = new HashMap();
    private String defaultNamespace;

    public XMLWriterNamespaceManager(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    public void setPrefix(String prefix, String namespace) {
        this.prefixNamespaceMap.put(prefix, namespace);
        this.namespacePrefixMap.put(namespace, prefix);
    }

    public String getPrefixForNamespace(String namespace) {
        return (String)this.namespacePrefixMap.get(namespace);
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.prefixNamespaceMap.get(prefix);
    }

    public void createPrefixForNamespace(String namespace) {
        if (!this.namespacePrefixMap.containsKey(namespace)) {
            int counter = 1;
            while (this.prefixNamespaceMap.get("p" + counter) != null) {
                ++counter;
            }
            this.setPrefix("p" + counter, namespace);
        }
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public Collection getPrefixes() {
        return new ArrayList(this.prefixNamespaceMap.keySet());
    }

    public Collection getNamespaces() {
        return new ArrayList(this.namespacePrefixMap.keySet());
    }
}

