/*
 * This source code is made available under the terms of the
 * Common Public License Version 1.0 distibuted along with the
 * source code package.
 */
package de.uka.cmtm.serviceregistry.query;

import java.io.IOException;
import java.util.List;

/**
 * This interface describes classes that can be used to search for services.
 * 
 * @author tilmann
 */
public interface ServiceLocator {

	/**
	 * This method can be used to search for services suitable to the given
	 * searchParameters. The resulting list may also contain services that do
	 * not perfectly match the parameters. This is indicated with a relevance
	 * below 1.
	 * 
	 * @param searchParameter
	 *            the parameters the services shoud have
	 * @return a list of search results sorted by relevance
	 */
	public List<ServiceInfo> findServices(ServiceParameter searchParameter)
			throws IOException;

	/**
	 * Sets a ServiceLocatorEventListener to be notified of events during search
	 * 
	 * @param listener
	 *            the ServiceLocatorEventListener to be set
	 */
	public void addServiceLocatorEventListener(
			ServiceLocatorEventListener listener);

	/**
	 * Removes a previously set ServiceLocatorEventListener
	 * 
	 * @param listener
	 *            the ServiceLocatorEventListener to be removed
	 */
	public void removeServiceLocatorEventListener(
			ServiceLocatorEventListener listener);

}
